% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_get_associated_package_group}
\alias{codeartifact_get_associated_package_group}
\title{Returns the most closely associated package group to the specified
package}
\usage{
codeartifact_get_associated_package_group(
  domain,
  domainOwner = NULL,
  format,
  namespace = NULL,
  package
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the package from which to get the
associated package group.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{format}{[required] The format of the package from which to get the associated package
group.}

\item{namespace}{The namespace of the package from which to get the associated package
group. The package component that specifies its namespace depends on its
type. For example:

The namespace is required when getting associated package groups from
packages of the following formats:
\itemize{
\item Maven
\item Swift
\item generic
\item The namespace of a Maven package version is its \code{groupId}.
\item The namespace of an npm or Swift package version is its \code{scope}.
\item The namespace of a generic package is its \code{namespace}.
\item Python, NuGet, Ruby, and Cargo package versions do not contain a
corresponding component, package versions of those formats do not
have a namespace.
}}

\item{package}{[required] The package from which to get the associated package group.}
}
\description{
Returns the most closely associated package group to the specified package. This API does not require that the package exist in any repository in the domain. As such, \code{\link[=codeartifact_get_associated_package_group]{get_associated_package_group}} can be used to see which package group's origin configuration applies to a package before that package is in a repository. This can be helpful to check if public packages are blocked without ingesting them.

See \url{https://www.paws-r-sdk.com/docs/codeartifact_get_associated_package_group/} for full documentation.
}
\keyword{internal}
