% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_list_action_types}
\alias{codepipeline_list_action_types}
\title{Gets a summary of all AWS CodePipeline action types associated with your
account}
\usage{
codepipeline_list_action_types(actionOwnerFilter, nextToken)
}
\arguments{
\item{actionOwnerFilter}{Filters the list of action types to those created by a specified entity.}

\item{nextToken}{An identifier that was returned from the previous list action types
call, which can be used to return the next set of action types in the
list.}
}
\value{
A list with the following syntax:\preformatted{list(
  actionTypes = list(
    list(
      id = list(
        category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
        owner = "AWS"|"ThirdParty"|"Custom",
        provider = "string",
        version = "string"
      ),
      settings = list(
        thirdPartyConfigurationUrl = "string",
        entityUrlTemplate = "string",
        executionUrlTemplate = "string",
        revisionUrlTemplate = "string"
      ),
      actionConfigurationProperties = list(
        list(
          name = "string",
          required = TRUE|FALSE,
          key = TRUE|FALSE,
          secret = TRUE|FALSE,
          queryable = TRUE|FALSE,
          description = "string",
          type = "String"|"Number"|"Boolean"
        )
      ),
      inputArtifactDetails = list(
        minimumCount = 123,
        maximumCount = 123
      ),
      outputArtifactDetails = list(
        minimumCount = 123,
        maximumCount = 123
      )
    )
  ),
  nextToken = "string"
)
}
}
\description{
Gets a summary of all AWS CodePipeline action types associated with your
account.
}
\section{Request syntax}{
\preformatted{svc$list_action_types(
  actionOwnerFilter = "AWS"|"ThirdParty"|"Custom",
  nextToken = "string"
)
}
}

\keyword{internal}
