% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_list_deployment_instances}
\alias{codedeploy_list_deployment_instances}
\title{The newer BatchGetDeploymentTargets should be used instead because it
works with all compute types}
\usage{
codedeploy_list_deployment_instances(deploymentId, nextToken,
  instanceStatusFilter, instanceTypeFilter)
}
\arguments{
\item{deploymentId}{[required] The unique ID of a deployment.}

\item{nextToken}{An identifier returned from the previous list deployment instances call.
It can be used to return the next set of deployment instances in the
list.}

\item{instanceStatusFilter}{A subset of instances to list by status:
\itemize{
\item \code{Pending}: Include those instances with pending deployments.
\item \code{InProgress}: Include those instances where deployments are still in
progress.
\item \code{Succeeded}: Include those instances with successful deployments.
\item \code{Failed}: Include those instances with failed deployments.
\item \code{Skipped}: Include those instances with skipped deployments.
\item \code{Unknown}: Include those instances with deployments in an unknown
state.
}}

\item{instanceTypeFilter}{The set of instances in a blue/green deployment, either those in the
original environment ("BLUE") or those in the replacement environment
("GREEN"), for which you want to view instance information.}
}
\value{
A list with the following syntax:\preformatted{list(
  instancesList = list(
    "string"
  ),
  nextToken = "string"
)
}
}
\description{
The newer
\code{\link[=codedeploy_batch_get_deployment_targets]{batch_get_deployment_targets}}
should be used instead because it works with all compute types.
\code{\link[=codedeploy_list_deployment_instances]{list_deployment_instances}}
throws an exception if it is used with a compute platform other than
EC2/On-premises or AWS Lambda.

Lists the instance for a deployment associated with the IAM user or AWS
account.
}
\section{Request syntax}{
\preformatted{svc$list_deployment_instances(
  deploymentId = "string",
  nextToken = "string",
  instanceStatusFilter = list(
    "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready"
  ),
  instanceTypeFilter = list(
    "Blue"|"Green"
  )
)
}
}

\keyword{internal}
