% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_create_approval_rule_template}
\alias{codecommit_create_approval_rule_template}
\title{Creates a template for approval rules that can then be associated with
one or more repositories in your AWS account}
\usage{
codecommit_create_approval_rule_template(approvalRuleTemplateName,
  approvalRuleTemplateContent, approvalRuleTemplateDescription)
}
\arguments{
\item{approvalRuleTemplateName}{[required] The name of the approval rule template. Provide descriptive names,
because this name is applied to the approval rules created automatically
in associated repositories.}

\item{approvalRuleTemplateContent}{[required] The content of the approval rule that is created on pull requests in
associated repositories. If you specify one or more destination
references (branches), approval rules are created in an associated
repository only if their destination references (branches) match those
specified in the template.

When you create the content of the approval rule template, you can
specify approvers in an approval pool in one of two ways:
\itemize{
\item \strong{CodeCommitApprovers}: This option only requires an AWS account
and a resource. It can be used for both IAM users and federated
access users whose name matches the provided resource name. This is
a very powerful option that offers a great deal of flexibility. For
example, if you specify the AWS account \emph{123456789012} and
\emph{Mary_Major}, all of the following are counted as approvals coming
from that user:
\itemize{
\item An IAM user in the account
(arn:aws:iam::\emph{123456789012}:user/\emph{Mary_Major})
\item A federated user identified in IAM as Mary_Major
(arn:aws:sts::\emph{123456789012}:federated-user/\emph{Mary_Major})
}

This option does not recognize an active session of someone assuming
the role of CodeCommitReview with a role session name of
\emph{Mary_Major}
(arn:aws:sts::\emph{123456789012}:assumed-role/CodeCommitReview/\emph{Mary_Major})
unless you include a wildcard (*Mary_Major).
\item \strong{Fully qualified ARN}: This option allows you to specify the fully
qualified Amazon Resource Name (ARN) of the IAM user or role.
}

For more information about IAM ARNs, wildcards, and formats, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{IAM Identifiers}
in the \emph{IAM User Guide}.}

\item{approvalRuleTemplateDescription}{The description of the approval rule template. Consider providing a
description that explains what this template does and when it might be
appropriate to associate it with repositories.}
}
\value{
A list with the following syntax:\preformatted{list(
  approvalRuleTemplate = list(
    approvalRuleTemplateId = "string",
    approvalRuleTemplateName = "string",
    approvalRuleTemplateDescription = "string",
    approvalRuleTemplateContent = "string",
    ruleContentSha256 = "string",
    lastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    creationDate = as.POSIXct(
      "2015-01-01"
    ),
    lastModifiedUser = "string"
  )
)
}
}
\description{
Creates a template for approval rules that can then be associated with
one or more repositories in your AWS account. When you associate a
template with a repository, AWS CodeCommit creates an approval rule that
matches the conditions of the template for all pull requests that meet
the conditions of the template. For more information, see
\code{\link[=codecommit_associate_approval_rule_template_with_repository]{associate_approval_rule_template_with_repository}}.
}
\section{Request syntax}{
\preformatted{svc$create_approval_rule_template(
  approvalRuleTemplateName = "string",
  approvalRuleTemplateContent = "string",
  approvalRuleTemplateDescription = "string"
)
}
}

\keyword{internal}
