% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_update_project}
\alias{codebuild_update_project}
\title{Changes the settings of a build project}
\usage{
codebuild_update_project(name, description, source, secondarySources,
  sourceVersion, secondarySourceVersions, artifacts, secondaryArtifacts,
  cache, environment, serviceRole, timeoutInMinutes,
  queuedTimeoutInMinutes, encryptionKey, tags, vpcConfig, badgeEnabled,
  logsConfig, fileSystemLocations, buildBatchConfig)
}
\arguments{
\item{name}{[required] The name of the build project.

You cannot change a build project's name.}

\item{description}{A new or replacement description of the build project.}

\item{source}{Information to be changed about the build input source code for the
build project.}

\item{secondarySources}{An array of \code{ProjectSource} objects.}

\item{sourceVersion}{A version of the build input to be built for this project. If not
specified, the latest version is used. If specified, it must be one of:
\itemize{
\item For AWS CodeCommit: the commit ID, branch, or Git tag to use.
\item For GitHub: the commit ID, pull request ID, branch name, or tag name
that corresponds to the version of the source code you want to
build. If a pull request ID is specified, it must use the format
\code{pr/pull-request-ID} (for example \code{pr/25}). If a branch name is
specified, the branch's HEAD commit ID is used. If not specified,
the default branch's HEAD commit ID is used.
\item For Bitbucket: the commit ID, branch name, or tag name that
corresponds to the version of the source code you want to build. If
a branch name is specified, the branch's HEAD commit ID is used. If
not specified, the default branch's HEAD commit ID is used.
\item For Amazon Simple Storage Service (Amazon S3): the version ID of the
object that represents the build input ZIP file to use.
}

If \code{sourceVersion} is specified at the build level, then that version
takes precedence over this \code{sourceVersion} (at the project level).

For more information, see \href{https://docs.aws.amazon.com/codebuild/latest/userguide/sample-source-version.html}{Source Version Sample with CodeBuild}
in the \emph{AWS CodeBuild User Guide}.}

\item{secondarySourceVersions}{An array of \code{ProjectSourceVersion} objects. If \code{secondarySourceVersions}
is specified at the build level, then they take over these
\code{secondarySourceVersions} (at the project level).}

\item{artifacts}{Information to be changed about the build output artifacts for the build
project.}

\item{secondaryArtifacts}{An array of \code{ProjectSource} objects.}

\item{cache}{Stores recently used information so that it can be quickly accessed at a
later time.}

\item{environment}{Information to be changed about the build environment for the build
project.}

\item{serviceRole}{The replacement ARN of the AWS Identity and Access Management (IAM) role
that enables AWS CodeBuild to interact with dependent AWS services on
behalf of the AWS account.}

\item{timeoutInMinutes}{The replacement value in minutes, from 5 to 480 (8 hours), for AWS
CodeBuild to wait before timing out any related build that did not get
marked as completed.}

\item{queuedTimeoutInMinutes}{The number of minutes a build is allowed to be queued before it times
out.}

\item{encryptionKey}{The AWS Key Management Service (AWS KMS) customer master key (CMK) to be
used for encrypting the build output artifacts.

You can use a cross-account KMS key to encrypt the build output
artifacts if your service role has permission to that key.

You can specify either the Amazon Resource Name (ARN) of the CMK or, if
available, the CMK's alias (using the format \verb{alias/<alias-name>}).}

\item{tags}{An updated list of tag key and value pairs associated with this build
project.

These tags are available for use by AWS services that support AWS
CodeBuild build project tags.}

\item{vpcConfig}{VpcConfig enables AWS CodeBuild to access resources in an Amazon VPC.}

\item{badgeEnabled}{Set this to true to generate a publicly accessible URL for your
project's build badge.}

\item{logsConfig}{Information about logs for the build project. A project can create logs
in Amazon CloudWatch Logs, logs in an S3 bucket, or both.}

\item{fileSystemLocations}{An array of \code{ProjectFileSystemLocation} objects for a CodeBuild build
project. A \code{ProjectFileSystemLocation} object specifies the
\code{identifier}, \code{location}, \code{mountOptions}, \code{mountPoint}, and \code{type} of a
file system created using Amazon Elastic File System.}

\item{buildBatchConfig}{}
}
\value{
A list with the following syntax:\preformatted{list(
  project = list(
    name = "string",
    arn = "string",
    description = "string",
    source = list(
      type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
      location = "string",
      gitCloneDepth = 123,
      gitSubmodulesConfig = list(
        fetchSubmodules = TRUE|FALSE
      ),
      buildspec = "string",
      auth = list(
        type = "OAUTH",
        resource = "string"
      ),
      reportBuildStatus = TRUE|FALSE,
      buildStatusConfig = list(
        context = "string",
        targetUrl = "string"
      ),
      insecureSsl = TRUE|FALSE,
      sourceIdentifier = "string"
    ),
    secondarySources = list(
      list(
        type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
        location = "string",
        gitCloneDepth = 123,
        gitSubmodulesConfig = list(
          fetchSubmodules = TRUE|FALSE
        ),
        buildspec = "string",
        auth = list(
          type = "OAUTH",
          resource = "string"
        ),
        reportBuildStatus = TRUE|FALSE,
        buildStatusConfig = list(
          context = "string",
          targetUrl = "string"
        ),
        insecureSsl = TRUE|FALSE,
        sourceIdentifier = "string"
      )
    ),
    sourceVersion = "string",
    secondarySourceVersions = list(
      list(
        sourceIdentifier = "string",
        sourceVersion = "string"
      )
    ),
    artifacts = list(
      type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
      location = "string",
      path = "string",
      namespaceType = "NONE"|"BUILD_ID",
      name = "string",
      packaging = "NONE"|"ZIP",
      overrideArtifactName = TRUE|FALSE,
      encryptionDisabled = TRUE|FALSE,
      artifactIdentifier = "string"
    ),
    secondaryArtifacts = list(
      list(
        type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
        location = "string",
        path = "string",
        namespaceType = "NONE"|"BUILD_ID",
        name = "string",
        packaging = "NONE"|"ZIP",
        overrideArtifactName = TRUE|FALSE,
        encryptionDisabled = TRUE|FALSE,
        artifactIdentifier = "string"
      )
    ),
    cache = list(
      type = "NO_CACHE"|"S3"|"LOCAL",
      location = "string",
      modes = list(
        "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
      )
    ),
    environment = list(
      type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
      image = "string",
      computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
      environmentVariables = list(
        list(
          name = "string",
          value = "string",
          type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
        )
      ),
      privilegedMode = TRUE|FALSE,
      certificate = "string",
      registryCredential = list(
        credential = "string",
        credentialProvider = "SECRETS_MANAGER"
      ),
      imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
    ),
    serviceRole = "string",
    timeoutInMinutes = 123,
    queuedTimeoutInMinutes = 123,
    encryptionKey = "string",
    tags = list(
      list(
        key = "string",
        value = "string"
      )
    ),
    created = as.POSIXct(
      "2015-01-01"
    ),
    lastModified = as.POSIXct(
      "2015-01-01"
    ),
    webhook = list(
      url = "string",
      payloadUrl = "string",
      secret = "string",
      branchFilter = "string",
      filterGroups = list(
        list(
          list(
            type = "EVENT"|"BASE_REF"|"HEAD_REF"|"ACTOR_ACCOUNT_ID"|"FILE_PATH"|"COMMIT_MESSAGE",
            pattern = "string",
            excludeMatchedPattern = TRUE|FALSE
          )
        )
      ),
      buildType = "BUILD"|"BUILD_BATCH",
      lastModifiedSecret = as.POSIXct(
        "2015-01-01"
      )
    ),
    vpcConfig = list(
      vpcId = "string",
      subnets = list(
        "string"
      ),
      securityGroupIds = list(
        "string"
      )
    ),
    badge = list(
      badgeEnabled = TRUE|FALSE,
      badgeRequestUrl = "string"
    ),
    logsConfig = list(
      cloudWatchLogs = list(
        status = "ENABLED"|"DISABLED",
        groupName = "string",
        streamName = "string"
      ),
      s3Logs = list(
        status = "ENABLED"|"DISABLED",
        location = "string",
        encryptionDisabled = TRUE|FALSE
      )
    ),
    fileSystemLocations = list(
      list(
        type = "EFS",
        location = "string",
        mountPoint = "string",
        identifier = "string",
        mountOptions = "string"
      )
    ),
    buildBatchConfig = list(
      serviceRole = "string",
      combineArtifacts = TRUE|FALSE,
      restrictions = list(
        maximumBuildsAllowed = 123,
        computeTypesAllowed = list(
          "string"
        )
      ),
      timeoutInMins = 123
    )
  )
)
}
}
\description{
Changes the settings of a build project.
}
\section{Request syntax}{
\preformatted{svc$update_project(
  name = "string",
  description = "string",
  source = list(
    type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
    location = "string",
    gitCloneDepth = 123,
    gitSubmodulesConfig = list(
      fetchSubmodules = TRUE|FALSE
    ),
    buildspec = "string",
    auth = list(
      type = "OAUTH",
      resource = "string"
    ),
    reportBuildStatus = TRUE|FALSE,
    buildStatusConfig = list(
      context = "string",
      targetUrl = "string"
    ),
    insecureSsl = TRUE|FALSE,
    sourceIdentifier = "string"
  ),
  secondarySources = list(
    list(
      type = "CODECOMMIT"|"CODEPIPELINE"|"GITHUB"|"S3"|"BITBUCKET"|"GITHUB_ENTERPRISE"|"NO_SOURCE",
      location = "string",
      gitCloneDepth = 123,
      gitSubmodulesConfig = list(
        fetchSubmodules = TRUE|FALSE
      ),
      buildspec = "string",
      auth = list(
        type = "OAUTH",
        resource = "string"
      ),
      reportBuildStatus = TRUE|FALSE,
      buildStatusConfig = list(
        context = "string",
        targetUrl = "string"
      ),
      insecureSsl = TRUE|FALSE,
      sourceIdentifier = "string"
    )
  ),
  sourceVersion = "string",
  secondarySourceVersions = list(
    list(
      sourceIdentifier = "string",
      sourceVersion = "string"
    )
  ),
  artifacts = list(
    type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
    location = "string",
    path = "string",
    namespaceType = "NONE"|"BUILD_ID",
    name = "string",
    packaging = "NONE"|"ZIP",
    overrideArtifactName = TRUE|FALSE,
    encryptionDisabled = TRUE|FALSE,
    artifactIdentifier = "string"
  ),
  secondaryArtifacts = list(
    list(
      type = "CODEPIPELINE"|"S3"|"NO_ARTIFACTS",
      location = "string",
      path = "string",
      namespaceType = "NONE"|"BUILD_ID",
      name = "string",
      packaging = "NONE"|"ZIP",
      overrideArtifactName = TRUE|FALSE,
      encryptionDisabled = TRUE|FALSE,
      artifactIdentifier = "string"
    )
  ),
  cache = list(
    type = "NO_CACHE"|"S3"|"LOCAL",
    location = "string",
    modes = list(
      "LOCAL_DOCKER_LAYER_CACHE"|"LOCAL_SOURCE_CACHE"|"LOCAL_CUSTOM_CACHE"
    )
  ),
  environment = list(
    type = "WINDOWS_CONTAINER"|"LINUX_CONTAINER"|"LINUX_GPU_CONTAINER"|"ARM_CONTAINER"|"WINDOWS_SERVER_2019_CONTAINER",
    image = "string",
    computeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE"|"BUILD_GENERAL1_2XLARGE",
    environmentVariables = list(
      list(
        name = "string",
        value = "string",
        type = "PLAINTEXT"|"PARAMETER_STORE"|"SECRETS_MANAGER"
      )
    ),
    privilegedMode = TRUE|FALSE,
    certificate = "string",
    registryCredential = list(
      credential = "string",
      credentialProvider = "SECRETS_MANAGER"
    ),
    imagePullCredentialsType = "CODEBUILD"|"SERVICE_ROLE"
  ),
  serviceRole = "string",
  timeoutInMinutes = 123,
  queuedTimeoutInMinutes = 123,
  encryptionKey = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  vpcConfig = list(
    vpcId = "string",
    subnets = list(
      "string"
    ),
    securityGroupIds = list(
      "string"
    )
  ),
  badgeEnabled = TRUE|FALSE,
  logsConfig = list(
    cloudWatchLogs = list(
      status = "ENABLED"|"DISABLED",
      groupName = "string",
      streamName = "string"
    ),
    s3Logs = list(
      status = "ENABLED"|"DISABLED",
      location = "string",
      encryptionDisabled = TRUE|FALSE
    )
  ),
  fileSystemLocations = list(
    list(
      type = "EFS",
      location = "string",
      mountPoint = "string",
      identifier = "string",
      mountOptions = "string"
    )
  ),
  buildBatchConfig = list(
    serviceRole = "string",
    combineArtifacts = TRUE|FALSE,
    restrictions = list(
      maximumBuildsAllowed = 123,
      computeTypesAllowed = list(
        "string"
      )
    ),
    timeoutInMins = 123
  )
)
}
}

\keyword{internal}
