% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_create_global_cluster}
\alias{neptune_create_global_cluster}
\title{Creates a Neptune global database spread across multiple Amazon Regions}
\usage{
neptune_create_global_cluster(
  GlobalClusterIdentifier,
  SourceDBClusterIdentifier = NULL,
  Engine = NULL,
  EngineVersion = NULL,
  DeletionProtection = NULL,
  StorageEncrypted = NULL
)
}
\arguments{
\item{GlobalClusterIdentifier}{[required] The cluster identifier of the new global database cluster.}

\item{SourceDBClusterIdentifier}{(\emph{Optional}) The Amazon Resource Name (ARN) of an existing Neptune DB
cluster to use as the primary cluster of the new global database.}

\item{Engine}{The name of the database engine to be used in the global database.

Valid values: \code{neptune}}

\item{EngineVersion}{The Neptune engine version to be used by the global database.

Valid values: \verb{1.2.0.0} or above.}

\item{DeletionProtection}{The deletion protection setting for the new global database. The global
database can't be deleted when deletion protection is enabled.}

\item{StorageEncrypted}{The storage encryption setting for the new global database cluster.}
}
\description{
Creates a Neptune global database spread across multiple Amazon Regions. The global database contains a single primary cluster with read-write capability, and read-only secondary clusters that receive data from the primary cluster through high-speed replication performed by the Neptune storage subsystem.

See \url{https://www.paws-r-sdk.com/docs/neptune_create_global_cluster/} for full documentation.
}
\keyword{internal}
