% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_create_hsm_client_certificate}
\alias{redshift_create_hsm_client_certificate}
\title{Creates an HSM client certificate that an Amazon Redshift cluster will
use to connect to the client's HSM in order to store and retrieve the
keys used to encrypt the cluster databases}
\usage{
redshift_create_hsm_client_certificate(HsmClientCertificateIdentifier,
  Tags)
}
\arguments{
\item{HsmClientCertificateIdentifier}{[required] The identifier to be assigned to the new HSM client certificate that the
cluster will use to connect to the HSM to use the database encryption
keys.}

\item{Tags}{A list of tag instances.}
}
\value{
A list with the following syntax:\preformatted{list(
  HsmClientCertificate = list(
    HsmClientCertificateIdentifier = "string",
    HsmClientCertificatePublicKey = "string",
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}
\description{
Creates an HSM client certificate that an Amazon Redshift cluster will
use to connect to the client's HSM in order to store and retrieve the
keys used to encrypt the cluster databases.

The command returns a public key, which you must store in the HSM. In
addition to creating the HSM certificate, you must create an Amazon
Redshift HSM configuration that provides a cluster the information
needed to store and use encryption keys in the HSM. For more
information, go to \href{https://docs.aws.amazon.com/redshift/latest/mgmt/}{Hardware Security Modules} in the
Amazon Redshift Cluster Management Guide.
}
\section{Request syntax}{
\preformatted{svc$create_hsm_client_certificate(
  HsmClientCertificateIdentifier = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
