% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptune_operations.R
\name{neptune_create_db_cluster}
\alias{neptune_create_db_cluster}
\title{Creates a new Amazon Neptune DB cluster}
\usage{
neptune_create_db_cluster(AvailabilityZones, BackupRetentionPeriod,
  CharacterSetName, DatabaseName, DBClusterIdentifier,
  DBClusterParameterGroupName, VpcSecurityGroupIds, DBSubnetGroupName,
  Engine, EngineVersion, Port, MasterUsername, MasterUserPassword,
  OptionGroupName, PreferredBackupWindow, PreferredMaintenanceWindow,
  ReplicationSourceIdentifier, Tags, StorageEncrypted, KmsKeyId,
  PreSignedUrl, EnableIAMDatabaseAuthentication,
  EnableCloudwatchLogsExports, DeletionProtection)
}
\arguments{
\item{AvailabilityZones}{A list of EC2 Availability Zones that instances in the DB cluster can be
created in.}

\item{BackupRetentionPeriod}{The number of days for which automated backups are retained. You must
specify a minimum value of 1.

Default: 1

Constraints:
\itemize{
\item Must be a value from 1 to 35
}}

\item{CharacterSetName}{\emph{(Not supported by Neptune)}}

\item{DatabaseName}{The name for your database of up to 64 alpha-numeric characters. If you
do not provide a name, Amazon Neptune will not create a database in the
DB cluster you are creating.}

\item{DBClusterIdentifier}{[required] The DB cluster identifier. This parameter is stored as a lowercase
string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}

Example: \code{my-cluster1}}

\item{DBClusterParameterGroupName}{The name of the DB cluster parameter group to associate with this DB
cluster. If this argument is omitted, the default is used.

Constraints:
\itemize{
\item If supplied, must match the name of an existing
DBClusterParameterGroup.
}}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with this DB cluster.}

\item{DBSubnetGroupName}{A DB subnet group to associate with this DB cluster.

Constraints: Must match the name of an existing DBSubnetGroup. Must not
be default.

Example: \code{mySubnetgroup}}

\item{Engine}{[required] The name of the database engine to be used for this DB cluster.

Valid Values: \code{neptune}}

\item{EngineVersion}{The version number of the database engine to use for the new DB cluster.

Example: \verb{1.0.2.1}}

\item{Port}{The port number on which the instances in the DB cluster accept
connections.

Default: \code{8182}}

\item{MasterUsername}{The name of the master user for the DB cluster.

Constraints:
\itemize{
\item Must be 1 to 16 letters or numbers.
\item First character must be a letter.
\item Cannot be a reserved word for the chosen database engine.
}}

\item{MasterUserPassword}{The password for the master database user. This password can contain any
printable ASCII character except "/", """, or "@".

Constraints: Must contain from 8 to 41 characters.}

\item{OptionGroupName}{\emph{(Not supported by Neptune)}}

\item{PreferredBackupWindow}{The daily time range during which automated backups are created if
automated backups are enabled using the \code{BackupRetentionPeriod}
parameter.

The default is a 30-minute window selected at random from an 8-hour
block of time for each AWS Region. To see the time blocks available, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/}{Adjusting the Preferred Maintenance Window} in the
\emph{Amazon Neptune User Guide.}

Constraints:
\itemize{
\item Must be in the format \code{hh24:mi-hh24:mi}.
\item Must be in Universal Coordinated Time (UTC).
\item Must not conflict with the preferred maintenance window.
\item Must be at least 30 minutes.
}}

\item{PreferredMaintenanceWindow}{The weekly time range during which system maintenance can occur, in
Universal Coordinated Time (UTC).

Format: \code{ddd:hh24:mi-ddd:hh24:mi}

The default is a 30-minute window selected at random from an 8-hour
block of time for each AWS Region, occurring on a random day of the
week. To see the time blocks available, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/}{Adjusting the Preferred Maintenance Window} in the
\emph{Amazon Neptune User Guide.}

Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.

Constraints: Minimum 30-minute window.}

\item{ReplicationSourceIdentifier}{The Amazon Resource Name (ARN) of the source DB instance or DB cluster
if this DB cluster is created as a Read Replica.}

\item{Tags}{The tags to assign to the new DB cluster.}

\item{StorageEncrypted}{Specifies whether the DB cluster is encrypted.}

\item{KmsKeyId}{The AWS KMS key identifier for an encrypted DB cluster.

The KMS key identifier is the Amazon Resource Name (ARN) for the KMS
encryption key. If you are creating a DB cluster with the same AWS
account that owns the KMS encryption key used to encrypt the new DB
cluster, then you can use the KMS key alias instead of the ARN for the
KMS encryption key.

If an encryption key is not specified in \code{KmsKeyId}:
\itemize{
\item If \code{ReplicationSourceIdentifier} identifies an encrypted source,
then Amazon Neptune will use the encryption key used to encrypt the
source. Otherwise, Amazon Neptune will use your default encryption
key.
\item If the \code{StorageEncrypted} parameter is true and
\code{ReplicationSourceIdentifier} is not specified, then Amazon Neptune
will use your default encryption key.
}

AWS KMS creates the default encryption key for your AWS account. Your
AWS account has a different default encryption key for each AWS Region.

If you create a Read Replica of an encrypted DB cluster in another AWS
Region, you must set \code{KmsKeyId} to a KMS key ID that is valid in the
destination AWS Region. This key is used to encrypt the Read Replica in
that AWS Region.}

\item{PreSignedUrl}{This parameter is not currently supported.}

\item{EnableIAMDatabaseAuthentication}{Not supported by Neptune.}

\item{EnableCloudwatchLogsExports}{The list of log types that need to be enabled for exporting to
CloudWatch Logs.}

\item{DeletionProtection}{A value that indicates whether the DB cluster has deletion protection
enabled. The database can't be deleted when deletion protection is
enabled. By default, deletion protection is enabled.}
}
\description{
Creates a new Amazon Neptune DB cluster.

You can use the \code{ReplicationSourceIdentifier} parameter to create the DB
cluster as a Read Replica of another DB cluster or Amazon Neptune DB
instance.

Note that when you create a new cluster using \code{CreateDBCluster}
directly, deletion protection is disabled by default (when you create a
new production cluster in the console, deletion protection is enabled by
default). You can only delete a DB cluster if its \code{DeletionProtection}
field is set to \code{false}.
}
\section{Request syntax}{
\preformatted{svc$create_db_cluster(
  AvailabilityZones = list(
    "string"
  ),
  BackupRetentionPeriod = 123,
  CharacterSetName = "string",
  DatabaseName = "string",
  DBClusterIdentifier = "string",
  DBClusterParameterGroupName = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  DBSubnetGroupName = "string",
  Engine = "string",
  EngineVersion = "string",
  Port = 123,
  MasterUsername = "string",
  MasterUserPassword = "string",
  OptionGroupName = "string",
  PreferredBackupWindow = "string",
  PreferredMaintenanceWindow = "string",
  ReplicationSourceIdentifier = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  StorageEncrypted = TRUE|FALSE,
  KmsKeyId = "string",
  PreSignedUrl = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  DeletionProtection = TRUE|FALSE
)
}
}

\keyword{internal}
