% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointsmsvoicev2_operations.R
\name{pinpointsmsvoicev2_update_pool}
\alias{pinpointsmsvoicev2_update_pool}
\title{Updates the configuration of an existing pool}
\usage{
pinpointsmsvoicev2_update_pool(
  PoolId,
  TwoWayEnabled = NULL,
  TwoWayChannelArn = NULL,
  TwoWayChannelRole = NULL,
  SelfManagedOptOutsEnabled = NULL,
  OptOutListName = NULL,
  SharedRoutesEnabled = NULL,
  DeletionProtectionEnabled = NULL
)
}
\arguments{
\item{PoolId}{[required] The unique identifier of the pool to update. Valid values are either the
PoolId or PoolArn.}

\item{TwoWayEnabled}{By default this is set to false. When set to true you can receive
incoming text messages from your end recipients.}

\item{TwoWayChannelArn}{The Amazon Resource Name (ARN) of the two way channel.}

\item{TwoWayChannelRole}{An optional IAM Role Arn for a service to assume, to be able to post
inbound SMS messages.}

\item{SelfManagedOptOutsEnabled}{By default this is set to false. When an end recipient sends a message
that begins with HELP or STOP to one of your dedicated numbers, AWS End
User Messaging SMS and Voice automatically replies with a customizable
message and adds the end recipient to the OptOutList. When set to true
you're responsible for responding to HELP and STOP requests. You're also
responsible for tracking and honoring opt-out requests.}

\item{OptOutListName}{The OptOutList to associate with the pool. Valid values are either
OptOutListName or OptOutListArn.}

\item{SharedRoutesEnabled}{Indicates whether shared routes are enabled for the pool.}

\item{DeletionProtectionEnabled}{When set to true the pool can't be deleted.}
}
\description{
Updates the configuration of an existing pool. You can update the opt-out list, enable or disable two-way messaging, change the \code{TwoWayChannelArn}, enable or disable self-managed opt-outs, enable or disable deletion protection, and enable or disable shared routes.

See \url{https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_update_pool/} for full documentation.
}
\keyword{internal}
