% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_start_contact_evaluation}
\alias{connect_start_contact_evaluation}
\title{Starts an empty evaluation in the specified Amazon Connect instance,
using the given evaluation form for the particular contact}
\usage{
connect_start_contact_evaluation(
  InstanceId,
  ContactId,
  EvaluationFormId,
  ClientToken = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{ContactId}{[required] The identifier of the contact in this instance of Amazon Connect.}

\item{EvaluationFormId}{[required] The unique identifier for the evaluation form.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}
}
\description{
Starts an empty evaluation in the specified Amazon Connect instance, using the given evaluation form for the particular contact. The evaluation form version used for the contact evaluation corresponds to the currently activated version. If no version is activated for the evaluation form, the contact evaluation cannot be started.

See \url{https://www.paws-r-sdk.com/docs/connect_start_contact_evaluation/} for full documentation.
}
\keyword{internal}
