% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_contact_flow}
\alias{connect_create_contact_flow}
\title{Creates a flow for the specified Amazon Connect instance}
\usage{
connect_create_contact_flow(
  InstanceId,
  Name,
  Type,
  Description = NULL,
  Content,
  Tags = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{Name}{[required] The name of the flow.}

\item{Type}{[required] The type of the flow. For descriptions of the available types, see
\href{https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types}{Choose a flow type}
in the \emph{Amazon Connect Administrator Guide}.}

\item{Description}{The description of the flow.}

\item{Content}{[required] The JSON string that represents the content of the flow. For an example,
see \href{https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html}{Example flow in Amazon Connect Flow language}.

Length Constraints: Minimum length of 1. Maximum length of 256000.}

\item{Tags}{The tags used to organize, track, or control access for this resource.
For example, \{ "Tags": \{"key1":"value1", "key2":"value2"\} \}.}
}
\description{
Creates a flow for the specified Amazon Connect instance.

See \url{https://www.paws-r-sdk.com/docs/connect_create_contact_flow/} for full documentation.
}
\keyword{internal}
