% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesv2_operations.R
\name{sesv2_send_email}
\alias{sesv2_send_email}
\title{Sends an email message}
\usage{
sesv2_send_email(
  FromEmailAddress = NULL,
  FromEmailAddressIdentityArn = NULL,
  Destination = NULL,
  ReplyToAddresses = NULL,
  FeedbackForwardingEmailAddress = NULL,
  FeedbackForwardingEmailAddressIdentityArn = NULL,
  Content,
  EmailTags = NULL,
  ConfigurationSetName = NULL,
  ListManagementOptions = NULL
)
}
\arguments{
\item{FromEmailAddress}{The email address to use as the "From" address for the email. The
address that you specify has to be verified.}

\item{FromEmailAddressIdentityArn}{This parameter is used only for sending authorization. It is the ARN of
the identity that is associated with the sending authorization policy
that permits you to use the email address specified in the
\code{FromEmailAddress} parameter.

For example, if the owner of example.com (which has ARN
arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a
policy to it that authorizes you to use sender@example.com, then you
would specify the \code{FromEmailAddressIdentityArn} to be
arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
\code{FromEmailAddress} to be sender@example.com.

For more information about sending authorization, see the \href{https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html}{Amazon SES Developer Guide}.

For Raw emails, the \code{FromEmailAddressIdentityArn} value overrides the
X-SES-SOURCE-ARN and X-SES-FROM-ARN headers specified in raw email
message content.}

\item{Destination}{An object that contains the recipients of the email message.}

\item{ReplyToAddresses}{The "Reply-to" email addresses for the message. When the recipient
replies to the message, each Reply-to address receives the reply.}

\item{FeedbackForwardingEmailAddress}{The address that you want bounce and complaint notifications to be sent
to.}

\item{FeedbackForwardingEmailAddressIdentityArn}{This parameter is used only for sending authorization. It is the ARN of
the identity that is associated with the sending authorization policy
that permits you to use the email address specified in the
\code{FeedbackForwardingEmailAddress} parameter.

For example, if the owner of example.com (which has ARN
arn:aws:ses:us-east-1:123456789012:identity/example.com) attaches a
policy to it that authorizes you to use feedback@example.com, then you
would specify the \code{FeedbackForwardingEmailAddressIdentityArn} to be
arn:aws:ses:us-east-1:123456789012:identity/example.com, and the
\code{FeedbackForwardingEmailAddress} to be feedback@example.com.

For more information about sending authorization, see the \href{https://docs.aws.amazon.com/ses/latest/dg/sending-authorization.html}{Amazon SES Developer Guide}.}

\item{Content}{[required] An object that contains the body of the message. You can send either a
Simple message Raw message or a template Message.}

\item{EmailTags}{A list of tags, in the form of name/value pairs, to apply to an email
that you send using the \code{\link[=sesv2_send_email]{send_email}} operation. Tags
correspond to characteristics of the email that you define, so that you
can publish email sending events.}

\item{ConfigurationSetName}{The name of the configuration set to use when sending the email.}

\item{ListManagementOptions}{An object used to specify a list or topic to which an email belongs,
which will be used when a contact chooses to unsubscribe.}
}
\description{
Sends an email message. You can use the Amazon SES API v2 to send the following types of messages:

See \url{https://www.paws-r-sdk.com/docs/sesv2_send_email/} for full documentation.
}
\keyword{internal}
