% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointsmsvoicev2_operations.R
\name{pinpointsmsvoicev2_update_phone_number}
\alias{pinpointsmsvoicev2_update_phone_number}
\title{Updates the configuration of an existing origination phone number}
\usage{
pinpointsmsvoicev2_update_phone_number(
  PhoneNumberId,
  TwoWayEnabled = NULL,
  TwoWayChannelArn = NULL,
  SelfManagedOptOutsEnabled = NULL,
  OptOutListName = NULL,
  DeletionProtectionEnabled = NULL
)
}
\arguments{
\item{PhoneNumberId}{[required] The unique identifier of the phone number. Valid values for this field
can be either the PhoneNumberId or PhoneNumberArn.}

\item{TwoWayEnabled}{By default this is set to false. When set to true you can receive
incoming text messages from your end recipients.}

\item{TwoWayChannelArn}{The Amazon Resource Name (ARN) of the two way channel.}

\item{SelfManagedOptOutsEnabled}{By default this is set to false. When an end recipient sends a message
that begins with HELP or STOP to one of your dedicated numbers, Amazon
Pinpoint automatically replies with a customizable message and adds the
end recipient to the OptOutList. When set to true you're responsible for
responding to HELP and STOP requests. You're also responsible for
tracking and honoring opt-out requests.}

\item{OptOutListName}{The OptOutList to add the phone number to. Valid values for this field
can be either the OutOutListName or OutOutListArn.}

\item{DeletionProtectionEnabled}{By default this is set to false. When set to true the phone number can't
be deleted.}
}
\description{
Updates the configuration of an existing origination phone number. You can update the opt-out list, enable or disable two-way messaging, change the TwoWayChannelArn, enable or disable self-managed opt-outs, and enable or disable deletion protection.

See \url{https://www.paws-r-sdk.com/docs/pinpointsmsvoicev2_update_phone_number/} for full documentation.
}
\keyword{internal}
