% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_get_journey_date_range_kpi}
\alias{pinpoint_get_journey_date_range_kpi}
\title{Retrieves (queries) pre-aggregated data for a standard engagement metric
that applies to a journey}
\usage{
pinpoint_get_journey_date_range_kpi(ApplicationId, EndTime, JourneyId,
  KpiName, NextToken, PageSize, StartTime)
}
\arguments{
\item{ApplicationId}{[required] The unique identifier for the application. This identifier is displayed
as the \strong{Project ID} on the Amazon Pinpoint console.}

\item{EndTime}{The last date and time to retrieve data for, as part of an inclusive
date range that filters the query results. This value should be in
extended ISO 8601 format, for example: 2019-07-19T00:00:00Z for July 19,
2019 and 2019-07-19T20:00:00Z for 8:00 PM July 19, 2019.}

\item{JourneyId}{[required] The unique identifier for the journey.}

\item{KpiName}{[required] The name of the metric, also referred to as a \emph{key performance indicator
(KPI)}, to retrieve data for. This value describes the associated metric
and consists of two or more terms, which are comprised of lowercase
alphanumeric characters, separated by a hyphen. Examples are
email-open-rate and successful-delivery-rate. For a list of valid
values, see the \href{https://docs.aws.amazon.com/pinpoint/latest/developerguide/welcome.html}{Amazon Pinpoint Developer Guide}.}

\item{NextToken}{The string that specifies which page of results to return in a paginated
response. This parameter is currently not supported for application,
campaign, and journey metrics.}

\item{PageSize}{The maximum number of items to include in each page of a paginated
response. This parameter is currently not supported for application,
campaign, and journey metrics.}

\item{StartTime}{The first date and time to retrieve data for, as part of an inclusive
date range that filters the query results. This value should be in
extended ISO 8601 format, for example: 2019-07-15T00:00:00Z for July 15,
2019 and 2019-07-15T16:00:00Z for 4:00 PM July 15, 2019.}
}
\description{
Retrieves (queries) pre-aggregated data for a standard engagement metric
that applies to a journey.
}
\section{Request syntax}{
\preformatted{svc$get_journey_date_range_kpi(
  ApplicationId = "string",
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  JourneyId = "string",
  KpiName = "string",
  NextToken = "string",
  PageSize = "string",
  StartTime = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
