# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include pinpoint_service.R
NULL

#' Creates an application
#'
#'  <p>Creates an application.</p>
#'
#' @usage
#' pinpoint_create_app(CreateApplicationRequest)
#'
#' @param CreateApplicationRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$create_app(
#'   CreateApplicationRequest = list(
#'     Name = "string",
#'     tags = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_app
pinpoint_create_app <- function(CreateApplicationRequest) {
  op <- new_operation(
    name = "CreateApp",
    http_method = "POST",
    http_path = "/v1/apps",
    paginator = list()
  )
  input <- .pinpoint$create_app_input(CreateApplicationRequest = CreateApplicationRequest)
  output <- .pinpoint$create_app_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_app <- pinpoint_create_app

#' Creates a new campaign for an application or updates the settings of an
#' existing campaign for an application
#'
#' Creates a new campaign for an application or updates the settings of an
#' existing campaign for an application.
#'
#' @usage
#' pinpoint_create_campaign(ApplicationId, WriteCampaignRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param WriteCampaignRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$create_campaign(
#'   ApplicationId = "string",
#'   WriteCampaignRequest = list(
#'     AdditionalTreatments = list(
#'       list(
#'         MessageConfiguration = list(
#'           ADMMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           APNSMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           BaiduMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           DefaultMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           EmailMessage = list(
#'             Body = "string",
#'             FromAddress = "string",
#'             HtmlBody = "string",
#'             Title = "string"
#'           ),
#'           GCMMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           SMSMessage = list(
#'             Body = "string",
#'             MessageType = "TRANSACTIONAL"|"PROMOTIONAL",
#'             SenderId = "string"
#'           )
#'         ),
#'         Schedule = list(
#'           EndTime = "string",
#'           EventFilter = list(
#'             Dimensions = list(
#'               Attributes = list(
#'                 list(
#'                   AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               EventType = list(
#'                 DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                 Values = list(
#'                   "string"
#'                 )
#'               ),
#'               Metrics = list(
#'                 list(
#'                   ComparisonOperator = "string",
#'                   Value = 123.0
#'                 )
#'               )
#'             ),
#'             FilterType = "SYSTEM"|"ENDPOINT"
#'           ),
#'           Frequency = "ONCE"|"HOURLY"|"DAILY"|"WEEKLY"|"MONTHLY"|"EVENT",
#'           IsLocalTime = TRUE|FALSE,
#'           QuietTime = list(
#'             End = "string",
#'             Start = "string"
#'           ),
#'           StartTime = "string",
#'           Timezone = "string"
#'         ),
#'         SizePercent = 123,
#'         TreatmentDescription = "string",
#'         TreatmentName = "string"
#'       )
#'     ),
#'     Description = "string",
#'     HoldoutPercent = 123,
#'     Hook = list(
#'       LambdaFunctionName = "string",
#'       Mode = "DELIVERY"|"FILTER",
#'       WebUrl = "string"
#'     ),
#'     IsPaused = TRUE|FALSE,
#'     Limits = list(
#'       Daily = 123,
#'       MaximumDuration = 123,
#'       MessagesPerSecond = 123,
#'       Total = 123
#'     ),
#'     MessageConfiguration = list(
#'       ADMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       APNSMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       BaiduMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       DefaultMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       EmailMessage = list(
#'         Body = "string",
#'         FromAddress = "string",
#'         HtmlBody = "string",
#'         Title = "string"
#'       ),
#'       GCMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       SMSMessage = list(
#'         Body = "string",
#'         MessageType = "TRANSACTIONAL"|"PROMOTIONAL",
#'         SenderId = "string"
#'       )
#'     ),
#'     Name = "string",
#'     Schedule = list(
#'       EndTime = "string",
#'       EventFilter = list(
#'         Dimensions = list(
#'           Attributes = list(
#'             list(
#'               AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'               Values = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           EventType = list(
#'             DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'             Values = list(
#'               "string"
#'             )
#'           ),
#'           Metrics = list(
#'             list(
#'               ComparisonOperator = "string",
#'               Value = 123.0
#'             )
#'           )
#'         ),
#'         FilterType = "SYSTEM"|"ENDPOINT"
#'       ),
#'       Frequency = "ONCE"|"HOURLY"|"DAILY"|"WEEKLY"|"MONTHLY"|"EVENT",
#'       IsLocalTime = TRUE|FALSE,
#'       QuietTime = list(
#'         End = "string",
#'         Start = "string"
#'       ),
#'       StartTime = "string",
#'       Timezone = "string"
#'     ),
#'     SegmentId = "string",
#'     SegmentVersion = 123,
#'     tags = list(
#'       "string"
#'     ),
#'     TreatmentDescription = "string",
#'     TreatmentName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_campaign
pinpoint_create_campaign <- function(ApplicationId, WriteCampaignRequest) {
  op <- new_operation(
    name = "CreateCampaign",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/campaigns",
    paginator = list()
  )
  input <- .pinpoint$create_campaign_input(ApplicationId = ApplicationId, WriteCampaignRequest = WriteCampaignRequest)
  output <- .pinpoint$create_campaign_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_campaign <- pinpoint_create_campaign

#' Creates a new export job for an application
#'
#' Creates a new export job for an application.
#'
#' @usage
#' pinpoint_create_export_job(ApplicationId, ExportJobRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param ExportJobRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$create_export_job(
#'   ApplicationId = "string",
#'   ExportJobRequest = list(
#'     RoleArn = "string",
#'     S3UrlPrefix = "string",
#'     SegmentId = "string",
#'     SegmentVersion = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_export_job
pinpoint_create_export_job <- function(ApplicationId, ExportJobRequest) {
  op <- new_operation(
    name = "CreateExportJob",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/jobs/export",
    paginator = list()
  )
  input <- .pinpoint$create_export_job_input(ApplicationId = ApplicationId, ExportJobRequest = ExportJobRequest)
  output <- .pinpoint$create_export_job_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_export_job <- pinpoint_create_export_job

#' Creates a new import job for an application
#'
#' Creates a new import job for an application.
#'
#' @usage
#' pinpoint_create_import_job(ApplicationId, ImportJobRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param ImportJobRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$create_import_job(
#'   ApplicationId = "string",
#'   ImportJobRequest = list(
#'     DefineSegment = TRUE|FALSE,
#'     ExternalId = "string",
#'     Format = "CSV"|"JSON",
#'     RegisterEndpoints = TRUE|FALSE,
#'     RoleArn = "string",
#'     S3Url = "string",
#'     SegmentId = "string",
#'     SegmentName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_import_job
pinpoint_create_import_job <- function(ApplicationId, ImportJobRequest) {
  op <- new_operation(
    name = "CreateImportJob",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/jobs/import",
    paginator = list()
  )
  input <- .pinpoint$create_import_job_input(ApplicationId = ApplicationId, ImportJobRequest = ImportJobRequest)
  output <- .pinpoint$create_import_job_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_import_job <- pinpoint_create_import_job

#' Creates a new segment for an application or updates the configuration,
#' dimension, and other settings for an existing segment that's associated
#' with an application
#'
#' Creates a new segment for an application or updates the configuration,
#' dimension, and other settings for an existing segment that\'s associated
#' with an application.
#'
#' @usage
#' pinpoint_create_segment(ApplicationId, WriteSegmentRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param WriteSegmentRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$create_segment(
#'   ApplicationId = "string",
#'   WriteSegmentRequest = list(
#'     Dimensions = list(
#'       Attributes = list(
#'         list(
#'           AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       Behavior = list(
#'         Recency = list(
#'           Duration = "HR_24"|"DAY_7"|"DAY_14"|"DAY_30",
#'           RecencyType = "ACTIVE"|"INACTIVE"
#'         )
#'       ),
#'       Demographic = list(
#'         AppVersion = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Channel = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         DeviceType = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Make = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Model = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Platform = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       Location = list(
#'         Country = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         GPSPoint = list(
#'           Coordinates = list(
#'             Latitude = 123.0,
#'             Longitude = 123.0
#'           ),
#'           RangeInKilometers = 123.0
#'         )
#'       ),
#'       Metrics = list(
#'         list(
#'           ComparisonOperator = "string",
#'           Value = 123.0
#'         )
#'       ),
#'       UserAttributes = list(
#'         list(
#'           AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       )
#'     ),
#'     Name = "string",
#'     SegmentGroups = list(
#'       Groups = list(
#'         list(
#'           Dimensions = list(
#'             list(
#'               Attributes = list(
#'                 list(
#'                   AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               Behavior = list(
#'                 Recency = list(
#'                   Duration = "HR_24"|"DAY_7"|"DAY_14"|"DAY_30",
#'                   RecencyType = "ACTIVE"|"INACTIVE"
#'                 )
#'               ),
#'               Demographic = list(
#'                 AppVersion = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Channel = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 DeviceType = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Make = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Model = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Platform = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               Location = list(
#'                 Country = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 GPSPoint = list(
#'                   Coordinates = list(
#'                     Latitude = 123.0,
#'                     Longitude = 123.0
#'                   ),
#'                   RangeInKilometers = 123.0
#'                 )
#'               ),
#'               Metrics = list(
#'                 list(
#'                   ComparisonOperator = "string",
#'                   Value = 123.0
#'                 )
#'               ),
#'               UserAttributes = list(
#'                 list(
#'                   AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               )
#'             )
#'           ),
#'           SourceSegments = list(
#'             list(
#'               Id = "string",
#'               Version = 123
#'             )
#'           ),
#'           SourceType = "ALL"|"ANY"|"NONE",
#'           Type = "ALL"|"ANY"|"NONE"
#'         )
#'       ),
#'       Include = "ALL"|"ANY"|"NONE"
#'     ),
#'     tags = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_create_segment
pinpoint_create_segment <- function(ApplicationId, WriteSegmentRequest) {
  op <- new_operation(
    name = "CreateSegment",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/segments",
    paginator = list()
  )
  input <- .pinpoint$create_segment_input(ApplicationId = ApplicationId, WriteSegmentRequest = WriteSegmentRequest)
  output <- .pinpoint$create_segment_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$create_segment <- pinpoint_create_segment

#' Disables the ADM channel for an application and deletes any existing
#' settings for the channel
#'
#' Disables the ADM channel for an application and deletes any existing
#' settings for the channel.
#'
#' @usage
#' pinpoint_delete_adm_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$delete_adm_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_adm_channel
pinpoint_delete_adm_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteAdmChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/adm",
    paginator = list()
  )
  input <- .pinpoint$delete_adm_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_adm_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_adm_channel <- pinpoint_delete_adm_channel

#' Disables the APNs channel for an application and deletes any existing
#' settings for the channel
#'
#' Disables the APNs channel for an application and deletes any existing
#' settings for the channel.
#'
#' @usage
#' pinpoint_delete_apns_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$delete_apns_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_apns_channel
pinpoint_delete_apns_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApnsChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/apns",
    paginator = list()
  )
  input <- .pinpoint$delete_apns_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_apns_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_apns_channel <- pinpoint_delete_apns_channel

#' Disables the APNs sandbox channel for an application and deletes any
#' existing settings for the channel
#'
#' Disables the APNs sandbox channel for an application and deletes any
#' existing settings for the channel.
#'
#' @usage
#' pinpoint_delete_apns_sandbox_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$delete_apns_sandbox_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_apns_sandbox_channel
pinpoint_delete_apns_sandbox_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApnsSandboxChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/apns_sandbox",
    paginator = list()
  )
  input <- .pinpoint$delete_apns_sandbox_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_apns_sandbox_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_apns_sandbox_channel <- pinpoint_delete_apns_sandbox_channel

#' Disables the APNs VoIP channel for an application and deletes any
#' existing settings for the channel
#'
#' Disables the APNs VoIP channel for an application and deletes any
#' existing settings for the channel.
#'
#' @usage
#' pinpoint_delete_apns_voip_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$delete_apns_voip_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_apns_voip_channel
pinpoint_delete_apns_voip_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApnsVoipChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/apns_voip",
    paginator = list()
  )
  input <- .pinpoint$delete_apns_voip_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_apns_voip_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_apns_voip_channel <- pinpoint_delete_apns_voip_channel

#' Disables the APNs VoIP sandbox channel for an application and deletes
#' any existing settings for the channel
#'
#' Disables the APNs VoIP sandbox channel for an application and deletes
#' any existing settings for the channel.
#'
#' @usage
#' pinpoint_delete_apns_voip_sandbox_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$delete_apns_voip_sandbox_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_apns_voip_sandbox_channel
pinpoint_delete_apns_voip_sandbox_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApnsVoipSandboxChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/apns_voip_sandbox",
    paginator = list()
  )
  input <- .pinpoint$delete_apns_voip_sandbox_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_apns_voip_sandbox_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_apns_voip_sandbox_channel <- pinpoint_delete_apns_voip_sandbox_channel

#' Deletes an application
#'
#' Deletes an application.
#'
#' @usage
#' pinpoint_delete_app(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$delete_app(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_app
pinpoint_delete_app <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteApp",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_app_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_app_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_app <- pinpoint_delete_app

#' Disables the Baidu channel for an application and deletes any existing
#' settings for the channel
#'
#' Disables the Baidu channel for an application and deletes any existing
#' settings for the channel.
#'
#' @usage
#' pinpoint_delete_baidu_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$delete_baidu_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_baidu_channel
pinpoint_delete_baidu_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteBaiduChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/baidu",
    paginator = list()
  )
  input <- .pinpoint$delete_baidu_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_baidu_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_baidu_channel <- pinpoint_delete_baidu_channel

#' Deletes a campaign from an application
#'
#' Deletes a campaign from an application.
#'
#' @usage
#' pinpoint_delete_campaign(ApplicationId, CampaignId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign.
#'
#' @section Request syntax:
#' ```
#' svc$delete_campaign(
#'   ApplicationId = "string",
#'   CampaignId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_campaign
pinpoint_delete_campaign <- function(ApplicationId, CampaignId) {
  op <- new_operation(
    name = "DeleteCampaign",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_campaign_input(ApplicationId = ApplicationId, CampaignId = CampaignId)
  output <- .pinpoint$delete_campaign_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_campaign <- pinpoint_delete_campaign

#' Disables the email channel for an application and deletes any existing
#' settings for the channel
#'
#' Disables the email channel for an application and deletes any existing
#' settings for the channel.
#'
#' @usage
#' pinpoint_delete_email_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$delete_email_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_email_channel
pinpoint_delete_email_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteEmailChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/email",
    paginator = list()
  )
  input <- .pinpoint$delete_email_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_email_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_email_channel <- pinpoint_delete_email_channel

#' Deletes an endpoint from an application
#'
#' Deletes an endpoint from an application.
#'
#' @usage
#' pinpoint_delete_endpoint(ApplicationId, EndpointId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EndpointId &#91;required&#93; The unique identifier for the endpoint.
#'
#' @section Request syntax:
#' ```
#' svc$delete_endpoint(
#'   ApplicationId = "string",
#'   EndpointId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_endpoint
pinpoint_delete_endpoint <- function(ApplicationId, EndpointId) {
  op <- new_operation(
    name = "DeleteEndpoint",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/endpoints/{endpoint-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_endpoint_input(ApplicationId = ApplicationId, EndpointId = EndpointId)
  output <- .pinpoint$delete_endpoint_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_endpoint <- pinpoint_delete_endpoint

#' Deletes the event stream for an application
#'
#' Deletes the event stream for an application.
#'
#' @usage
#' pinpoint_delete_event_stream(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$delete_event_stream(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_event_stream
pinpoint_delete_event_stream <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteEventStream",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/eventstream",
    paginator = list()
  )
  input <- .pinpoint$delete_event_stream_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_event_stream_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_event_stream <- pinpoint_delete_event_stream

#' Disables the GCM channel for an application and deletes any existing
#' settings for the channel
#'
#' Disables the GCM channel for an application and deletes any existing
#' settings for the channel.
#'
#' @usage
#' pinpoint_delete_gcm_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$delete_gcm_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_gcm_channel
pinpoint_delete_gcm_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteGcmChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/gcm",
    paginator = list()
  )
  input <- .pinpoint$delete_gcm_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_gcm_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_gcm_channel <- pinpoint_delete_gcm_channel

#' Deletes a segment from an application
#'
#' Deletes a segment from an application.
#'
#' @usage
#' pinpoint_delete_segment(ApplicationId, SegmentId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param SegmentId &#91;required&#93; The unique identifier for the segment.
#'
#' @section Request syntax:
#' ```
#' svc$delete_segment(
#'   ApplicationId = "string",
#'   SegmentId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_segment
pinpoint_delete_segment <- function(ApplicationId, SegmentId) {
  op <- new_operation(
    name = "DeleteSegment",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_segment_input(ApplicationId = ApplicationId, SegmentId = SegmentId)
  output <- .pinpoint$delete_segment_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_segment <- pinpoint_delete_segment

#' Disables the SMS channel for an application and deletes any existing
#' settings for the channel
#'
#' Disables the SMS channel for an application and deletes any existing
#' settings for the channel.
#'
#' @usage
#' pinpoint_delete_sms_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$delete_sms_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_sms_channel
pinpoint_delete_sms_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteSmsChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/sms",
    paginator = list()
  )
  input <- .pinpoint$delete_sms_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_sms_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_sms_channel <- pinpoint_delete_sms_channel

#' Deletes all the endpoints that are associated with a specific user ID
#'
#' Deletes all the endpoints that are associated with a specific user ID.
#'
#' @usage
#' pinpoint_delete_user_endpoints(ApplicationId, UserId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param UserId &#91;required&#93; The unique identifier for the user.
#'
#' @section Request syntax:
#' ```
#' svc$delete_user_endpoints(
#'   ApplicationId = "string",
#'   UserId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_user_endpoints
pinpoint_delete_user_endpoints <- function(ApplicationId, UserId) {
  op <- new_operation(
    name = "DeleteUserEndpoints",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/users/{user-id}",
    paginator = list()
  )
  input <- .pinpoint$delete_user_endpoints_input(ApplicationId = ApplicationId, UserId = UserId)
  output <- .pinpoint$delete_user_endpoints_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_user_endpoints <- pinpoint_delete_user_endpoints

#' Disables the voice channel for an application and deletes any existing
#' settings for the channel
#'
#' Disables the voice channel for an application and deletes any existing
#' settings for the channel.
#'
#' @usage
#' pinpoint_delete_voice_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$delete_voice_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_delete_voice_channel
pinpoint_delete_voice_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "DeleteVoiceChannel",
    http_method = "DELETE",
    http_path = "/v1/apps/{application-id}/channels/voice",
    paginator = list()
  )
  input <- .pinpoint$delete_voice_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$delete_voice_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$delete_voice_channel <- pinpoint_delete_voice_channel

#' Retrieves information about the status and settings of the ADM channel
#' for an application
#'
#' Retrieves information about the status and settings of the ADM channel
#' for an application.
#'
#' @usage
#' pinpoint_get_adm_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$get_adm_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_adm_channel
pinpoint_get_adm_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetAdmChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/adm",
    paginator = list()
  )
  input <- .pinpoint$get_adm_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_adm_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_adm_channel <- pinpoint_get_adm_channel

#' Retrieves information about the status and settings of the APNs channel
#' for an application
#'
#' Retrieves information about the status and settings of the APNs channel
#' for an application.
#'
#' @usage
#' pinpoint_get_apns_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$get_apns_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apns_channel
pinpoint_get_apns_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApnsChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/apns",
    paginator = list()
  )
  input <- .pinpoint$get_apns_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_apns_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apns_channel <- pinpoint_get_apns_channel

#' Retrieves information about the status and settings of the APNs sandbox
#' channel for an application
#'
#' Retrieves information about the status and settings of the APNs sandbox
#' channel for an application.
#'
#' @usage
#' pinpoint_get_apns_sandbox_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$get_apns_sandbox_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apns_sandbox_channel
pinpoint_get_apns_sandbox_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApnsSandboxChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/apns_sandbox",
    paginator = list()
  )
  input <- .pinpoint$get_apns_sandbox_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_apns_sandbox_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apns_sandbox_channel <- pinpoint_get_apns_sandbox_channel

#' Retrieves information about the status and settings of the APNs VoIP
#' channel for an application
#'
#' Retrieves information about the status and settings of the APNs VoIP
#' channel for an application.
#'
#' @usage
#' pinpoint_get_apns_voip_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$get_apns_voip_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apns_voip_channel
pinpoint_get_apns_voip_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApnsVoipChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/apns_voip",
    paginator = list()
  )
  input <- .pinpoint$get_apns_voip_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_apns_voip_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apns_voip_channel <- pinpoint_get_apns_voip_channel

#' Retrieves information about the status and settings of the APNs VoIP
#' sandbox channel for an application
#'
#' Retrieves information about the status and settings of the APNs VoIP
#' sandbox channel for an application.
#'
#' @usage
#' pinpoint_get_apns_voip_sandbox_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$get_apns_voip_sandbox_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apns_voip_sandbox_channel
pinpoint_get_apns_voip_sandbox_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApnsVoipSandboxChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/apns_voip_sandbox",
    paginator = list()
  )
  input <- .pinpoint$get_apns_voip_sandbox_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_apns_voip_sandbox_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apns_voip_sandbox_channel <- pinpoint_get_apns_voip_sandbox_channel

#' Retrieves information about an application
#'
#' Retrieves information about an application.
#'
#' @usage
#' pinpoint_get_app(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$get_app(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_app
pinpoint_get_app <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApp",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}",
    paginator = list()
  )
  input <- .pinpoint$get_app_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_app_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_app <- pinpoint_get_app

#' Retrieves information about the settings for an application
#'
#' Retrieves information about the settings for an application.
#'
#' @usage
#' pinpoint_get_application_settings(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$get_application_settings(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_application_settings
pinpoint_get_application_settings <- function(ApplicationId) {
  op <- new_operation(
    name = "GetApplicationSettings",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/settings",
    paginator = list()
  )
  input <- .pinpoint$get_application_settings_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_application_settings_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_application_settings <- pinpoint_get_application_settings

#' Retrieves information about all of your applications
#'
#' Retrieves information about all of your applications.
#'
#' @usage
#' pinpoint_get_apps(PageSize, Token)
#'
#' @param PageSize The maximum number of items to include on each page in a paginated
#' response.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_apps(
#'   PageSize = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_apps
pinpoint_get_apps <- function(PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetApps",
    http_method = "GET",
    http_path = "/v1/apps",
    paginator = list()
  )
  input <- .pinpoint$get_apps_input(PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_apps_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_apps <- pinpoint_get_apps

#' Retrieves information about the status and settings of the Baidu Cloud
#' Push channel for an application
#'
#' Retrieves information about the status and settings of the Baidu Cloud
#' Push channel for an application.
#'
#' @usage
#' pinpoint_get_baidu_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$get_baidu_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_baidu_channel
pinpoint_get_baidu_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetBaiduChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/baidu",
    paginator = list()
  )
  input <- .pinpoint$get_baidu_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_baidu_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_baidu_channel <- pinpoint_get_baidu_channel

#' Retrieves information about the status, configuration, and other
#' settings for a campaign
#'
#' Retrieves information about the status, configuration, and other
#' settings for a campaign.
#'
#' @usage
#' pinpoint_get_campaign(ApplicationId, CampaignId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign.
#'
#' @section Request syntax:
#' ```
#' svc$get_campaign(
#'   ApplicationId = "string",
#'   CampaignId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaign
pinpoint_get_campaign <- function(ApplicationId, CampaignId) {
  op <- new_operation(
    name = "GetCampaign",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}",
    paginator = list()
  )
  input <- .pinpoint$get_campaign_input(ApplicationId = ApplicationId, CampaignId = CampaignId)
  output <- .pinpoint$get_campaign_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaign <- pinpoint_get_campaign

#' Retrieves information about the activity performed by a campaign
#'
#' Retrieves information about the activity performed by a campaign.
#'
#' @usage
#' pinpoint_get_campaign_activities(ApplicationId, CampaignId, PageSize,
#'   Token)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign.
#' @param PageSize The maximum number of items to include on each page in a paginated
#' response.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_campaign_activities(
#'   ApplicationId = "string",
#'   CampaignId = "string",
#'   PageSize = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaign_activities
pinpoint_get_campaign_activities <- function(ApplicationId, CampaignId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetCampaignActivities",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}/activities",
    paginator = list()
  )
  input <- .pinpoint$get_campaign_activities_input(ApplicationId = ApplicationId, CampaignId = CampaignId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_campaign_activities_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaign_activities <- pinpoint_get_campaign_activities

#' Retrieves information about the status, configuration, and other
#' settings for a specific version of a campaign
#'
#' Retrieves information about the status, configuration, and other
#' settings for a specific version of a campaign.
#'
#' @usage
#' pinpoint_get_campaign_version(ApplicationId, CampaignId, Version)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign.
#' @param Version &#91;required&#93; The unique version number (Version property) for the campaign version.
#'
#' @section Request syntax:
#' ```
#' svc$get_campaign_version(
#'   ApplicationId = "string",
#'   CampaignId = "string",
#'   Version = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaign_version
pinpoint_get_campaign_version <- function(ApplicationId, CampaignId, Version) {
  op <- new_operation(
    name = "GetCampaignVersion",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}/versions/{version}",
    paginator = list()
  )
  input <- .pinpoint$get_campaign_version_input(ApplicationId = ApplicationId, CampaignId = CampaignId, Version = Version)
  output <- .pinpoint$get_campaign_version_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaign_version <- pinpoint_get_campaign_version

#' Retrieves information about the status, configuration, and other
#' settings for all versions of a specific campaign
#'
#' Retrieves information about the status, configuration, and other
#' settings for all versions of a specific campaign.
#'
#' @usage
#' pinpoint_get_campaign_versions(ApplicationId, CampaignId, PageSize,
#'   Token)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign.
#' @param PageSize The maximum number of items to include on each page in a paginated
#' response.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_campaign_versions(
#'   ApplicationId = "string",
#'   CampaignId = "string",
#'   PageSize = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaign_versions
pinpoint_get_campaign_versions <- function(ApplicationId, CampaignId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetCampaignVersions",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}/versions",
    paginator = list()
  )
  input <- .pinpoint$get_campaign_versions_input(ApplicationId = ApplicationId, CampaignId = CampaignId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_campaign_versions_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaign_versions <- pinpoint_get_campaign_versions

#' Retrieves information about the status, configuration, and other
#' settings for all the campaigns that are associated with an application
#'
#' Retrieves information about the status, configuration, and other
#' settings for all the campaigns that are associated with an application.
#'
#' @usage
#' pinpoint_get_campaigns(ApplicationId, PageSize, Token)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include on each page in a paginated
#' response.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_campaigns(
#'   ApplicationId = "string",
#'   PageSize = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_campaigns
pinpoint_get_campaigns <- function(ApplicationId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetCampaigns",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/campaigns",
    paginator = list()
  )
  input <- .pinpoint$get_campaigns_input(ApplicationId = ApplicationId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_campaigns_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_campaigns <- pinpoint_get_campaigns

#' Retrieves information about the history and status of each channel for
#' an application
#'
#' Retrieves information about the history and status of each channel for
#' an application.
#'
#' @usage
#' pinpoint_get_channels(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$get_channels(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_channels
pinpoint_get_channels <- function(ApplicationId) {
  op <- new_operation(
    name = "GetChannels",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels",
    paginator = list()
  )
  input <- .pinpoint$get_channels_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_channels_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_channels <- pinpoint_get_channels

#' Retrieves information about the status and settings of the email channel
#' for an application
#'
#' Retrieves information about the status and settings of the email channel
#' for an application.
#'
#' @usage
#' pinpoint_get_email_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$get_email_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_email_channel
pinpoint_get_email_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetEmailChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/email",
    paginator = list()
  )
  input <- .pinpoint$get_email_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_email_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_email_channel <- pinpoint_get_email_channel

#' Retrieves information about the settings and attributes of a specific
#' endpoint for an application
#'
#' Retrieves information about the settings and attributes of a specific
#' endpoint for an application.
#'
#' @usage
#' pinpoint_get_endpoint(ApplicationId, EndpointId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EndpointId &#91;required&#93; The unique identifier for the endpoint.
#'
#' @section Request syntax:
#' ```
#' svc$get_endpoint(
#'   ApplicationId = "string",
#'   EndpointId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_endpoint
pinpoint_get_endpoint <- function(ApplicationId, EndpointId) {
  op <- new_operation(
    name = "GetEndpoint",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/endpoints/{endpoint-id}",
    paginator = list()
  )
  input <- .pinpoint$get_endpoint_input(ApplicationId = ApplicationId, EndpointId = EndpointId)
  output <- .pinpoint$get_endpoint_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_endpoint <- pinpoint_get_endpoint

#' Retrieves information about the event stream settings for an application
#'
#' Retrieves information about the event stream settings for an
#' application.
#'
#' @usage
#' pinpoint_get_event_stream(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$get_event_stream(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_event_stream
pinpoint_get_event_stream <- function(ApplicationId) {
  op <- new_operation(
    name = "GetEventStream",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/eventstream",
    paginator = list()
  )
  input <- .pinpoint$get_event_stream_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_event_stream_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_event_stream <- pinpoint_get_event_stream

#' Retrieves information about the status and settings of a specific export
#' job for an application
#'
#' Retrieves information about the status and settings of a specific export
#' job for an application.
#'
#' @usage
#' pinpoint_get_export_job(ApplicationId, JobId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param JobId &#91;required&#93; The unique identifier for the job.
#'
#' @section Request syntax:
#' ```
#' svc$get_export_job(
#'   ApplicationId = "string",
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_export_job
pinpoint_get_export_job <- function(ApplicationId, JobId) {
  op <- new_operation(
    name = "GetExportJob",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/jobs/export/{job-id}",
    paginator = list()
  )
  input <- .pinpoint$get_export_job_input(ApplicationId = ApplicationId, JobId = JobId)
  output <- .pinpoint$get_export_job_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_export_job <- pinpoint_get_export_job

#' Retrieves information about the status and settings of all the export
#' jobs for an application
#'
#' Retrieves information about the status and settings of all the export
#' jobs for an application.
#'
#' @usage
#' pinpoint_get_export_jobs(ApplicationId, PageSize, Token)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include on each page in a paginated
#' response.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_export_jobs(
#'   ApplicationId = "string",
#'   PageSize = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_export_jobs
pinpoint_get_export_jobs <- function(ApplicationId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetExportJobs",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/jobs/export",
    paginator = list()
  )
  input <- .pinpoint$get_export_jobs_input(ApplicationId = ApplicationId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_export_jobs_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_export_jobs <- pinpoint_get_export_jobs

#' Retrieves information about the status and settings of the GCM channel
#' for an application
#'
#' Retrieves information about the status and settings of the GCM channel
#' for an application.
#'
#' @usage
#' pinpoint_get_gcm_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$get_gcm_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_gcm_channel
pinpoint_get_gcm_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetGcmChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/gcm",
    paginator = list()
  )
  input <- .pinpoint$get_gcm_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_gcm_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_gcm_channel <- pinpoint_get_gcm_channel

#' Retrieves information about the status and settings of a specific import
#' job for an application
#'
#' Retrieves information about the status and settings of a specific import
#' job for an application.
#'
#' @usage
#' pinpoint_get_import_job(ApplicationId, JobId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param JobId &#91;required&#93; The unique identifier for the job.
#'
#' @section Request syntax:
#' ```
#' svc$get_import_job(
#'   ApplicationId = "string",
#'   JobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_import_job
pinpoint_get_import_job <- function(ApplicationId, JobId) {
  op <- new_operation(
    name = "GetImportJob",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/jobs/import/{job-id}",
    paginator = list()
  )
  input <- .pinpoint$get_import_job_input(ApplicationId = ApplicationId, JobId = JobId)
  output <- .pinpoint$get_import_job_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_import_job <- pinpoint_get_import_job

#' Retrieves information about the status and settings of all the import
#' jobs for an application
#'
#' Retrieves information about the status and settings of all the import
#' jobs for an application.
#'
#' @usage
#' pinpoint_get_import_jobs(ApplicationId, PageSize, Token)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include on each page in a paginated
#' response.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_import_jobs(
#'   ApplicationId = "string",
#'   PageSize = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_import_jobs
pinpoint_get_import_jobs <- function(ApplicationId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetImportJobs",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/jobs/import",
    paginator = list()
  )
  input <- .pinpoint$get_import_jobs_input(ApplicationId = ApplicationId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_import_jobs_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_import_jobs <- pinpoint_get_import_jobs

#' Retrieves information about the configuration, dimension, and other
#' settings for a specific segment that's associated with an application
#'
#' Retrieves information about the configuration, dimension, and other
#' settings for a specific segment that\'s associated with an application.
#'
#' @usage
#' pinpoint_get_segment(ApplicationId, SegmentId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param SegmentId &#91;required&#93; The unique identifier for the segment.
#'
#' @section Request syntax:
#' ```
#' svc$get_segment(
#'   ApplicationId = "string",
#'   SegmentId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment
pinpoint_get_segment <- function(ApplicationId, SegmentId) {
  op <- new_operation(
    name = "GetSegment",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}",
    paginator = list()
  )
  input <- .pinpoint$get_segment_input(ApplicationId = ApplicationId, SegmentId = SegmentId)
  output <- .pinpoint$get_segment_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment <- pinpoint_get_segment

#' Retrieves information about the status and settings of the export jobs
#' for a segment
#'
#' Retrieves information about the status and settings of the export jobs
#' for a segment.
#'
#' @usage
#' pinpoint_get_segment_export_jobs(ApplicationId, PageSize, SegmentId,
#'   Token)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include on each page in a paginated
#' response.
#' @param SegmentId &#91;required&#93; The unique identifier for the segment.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_segment_export_jobs(
#'   ApplicationId = "string",
#'   PageSize = "string",
#'   SegmentId = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment_export_jobs
pinpoint_get_segment_export_jobs <- function(ApplicationId, PageSize = NULL, SegmentId, Token = NULL) {
  op <- new_operation(
    name = "GetSegmentExportJobs",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}/jobs/export",
    paginator = list()
  )
  input <- .pinpoint$get_segment_export_jobs_input(ApplicationId = ApplicationId, PageSize = PageSize, SegmentId = SegmentId, Token = Token)
  output <- .pinpoint$get_segment_export_jobs_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment_export_jobs <- pinpoint_get_segment_export_jobs

#' Retrieves information about the status and settings of the import jobs
#' for a segment
#'
#' Retrieves information about the status and settings of the import jobs
#' for a segment.
#'
#' @usage
#' pinpoint_get_segment_import_jobs(ApplicationId, PageSize, SegmentId,
#'   Token)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include on each page in a paginated
#' response.
#' @param SegmentId &#91;required&#93; The unique identifier for the segment.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_segment_import_jobs(
#'   ApplicationId = "string",
#'   PageSize = "string",
#'   SegmentId = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment_import_jobs
pinpoint_get_segment_import_jobs <- function(ApplicationId, PageSize = NULL, SegmentId, Token = NULL) {
  op <- new_operation(
    name = "GetSegmentImportJobs",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}/jobs/import",
    paginator = list()
  )
  input <- .pinpoint$get_segment_import_jobs_input(ApplicationId = ApplicationId, PageSize = PageSize, SegmentId = SegmentId, Token = Token)
  output <- .pinpoint$get_segment_import_jobs_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment_import_jobs <- pinpoint_get_segment_import_jobs

#' Retrieves information about the configuration, dimension, and other
#' settings for a specific version of a segment that's associated with an
#' application
#'
#' Retrieves information about the configuration, dimension, and other
#' settings for a specific version of a segment that\'s associated with an
#' application.
#'
#' @usage
#' pinpoint_get_segment_version(ApplicationId, SegmentId, Version)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param SegmentId &#91;required&#93; The unique identifier for the segment.
#' @param Version &#91;required&#93; The unique version number (Version property) for the campaign version.
#'
#' @section Request syntax:
#' ```
#' svc$get_segment_version(
#'   ApplicationId = "string",
#'   SegmentId = "string",
#'   Version = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment_version
pinpoint_get_segment_version <- function(ApplicationId, SegmentId, Version) {
  op <- new_operation(
    name = "GetSegmentVersion",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}/versions/{version}",
    paginator = list()
  )
  input <- .pinpoint$get_segment_version_input(ApplicationId = ApplicationId, SegmentId = SegmentId, Version = Version)
  output <- .pinpoint$get_segment_version_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment_version <- pinpoint_get_segment_version

#' Retrieves information about the configuration, dimension, and other
#' settings for all versions of a specific segment that's associated with
#' an application
#'
#' Retrieves information about the configuration, dimension, and other
#' settings for all versions of a specific segment that\'s associated with
#' an application.
#'
#' @usage
#' pinpoint_get_segment_versions(ApplicationId, PageSize, SegmentId, Token)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include on each page in a paginated
#' response.
#' @param SegmentId &#91;required&#93; The unique identifier for the segment.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_segment_versions(
#'   ApplicationId = "string",
#'   PageSize = "string",
#'   SegmentId = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segment_versions
pinpoint_get_segment_versions <- function(ApplicationId, PageSize = NULL, SegmentId, Token = NULL) {
  op <- new_operation(
    name = "GetSegmentVersions",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}/versions",
    paginator = list()
  )
  input <- .pinpoint$get_segment_versions_input(ApplicationId = ApplicationId, PageSize = PageSize, SegmentId = SegmentId, Token = Token)
  output <- .pinpoint$get_segment_versions_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segment_versions <- pinpoint_get_segment_versions

#' Retrieves information about the configuration, dimension, and other
#' settings for all the segments that are associated with an application
#'
#' Retrieves information about the configuration, dimension, and other
#' settings for all the segments that are associated with an application.
#'
#' @usage
#' pinpoint_get_segments(ApplicationId, PageSize, Token)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param PageSize The maximum number of items to include on each page in a paginated
#' response.
#' @param Token The NextToken string that specifies which page of results to return in a
#' paginated response.
#'
#' @section Request syntax:
#' ```
#' svc$get_segments(
#'   ApplicationId = "string",
#'   PageSize = "string",
#'   Token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_segments
pinpoint_get_segments <- function(ApplicationId, PageSize = NULL, Token = NULL) {
  op <- new_operation(
    name = "GetSegments",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/segments",
    paginator = list()
  )
  input <- .pinpoint$get_segments_input(ApplicationId = ApplicationId, PageSize = PageSize, Token = Token)
  output <- .pinpoint$get_segments_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_segments <- pinpoint_get_segments

#' Retrieves information about the status and settings of the SMS channel
#' for an application
#'
#' Retrieves information about the status and settings of the SMS channel
#' for an application.
#'
#' @usage
#' pinpoint_get_sms_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$get_sms_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_sms_channel
pinpoint_get_sms_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetSmsChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/sms",
    paginator = list()
  )
  input <- .pinpoint$get_sms_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_sms_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_sms_channel <- pinpoint_get_sms_channel

#' Retrieves information about all the endpoints that are associated with a
#' specific user ID
#'
#' Retrieves information about all the endpoints that are associated with a
#' specific user ID.
#'
#' @usage
#' pinpoint_get_user_endpoints(ApplicationId, UserId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param UserId &#91;required&#93; The unique identifier for the user.
#'
#' @section Request syntax:
#' ```
#' svc$get_user_endpoints(
#'   ApplicationId = "string",
#'   UserId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_user_endpoints
pinpoint_get_user_endpoints <- function(ApplicationId, UserId) {
  op <- new_operation(
    name = "GetUserEndpoints",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/users/{user-id}",
    paginator = list()
  )
  input <- .pinpoint$get_user_endpoints_input(ApplicationId = ApplicationId, UserId = UserId)
  output <- .pinpoint$get_user_endpoints_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_user_endpoints <- pinpoint_get_user_endpoints

#' Retrieves information about the status and settings of the voice channel
#' for an application
#'
#' Retrieves information about the status and settings of the voice channel
#' for an application.
#'
#' @usage
#' pinpoint_get_voice_channel(ApplicationId)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$get_voice_channel(
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_get_voice_channel
pinpoint_get_voice_channel <- function(ApplicationId) {
  op <- new_operation(
    name = "GetVoiceChannel",
    http_method = "GET",
    http_path = "/v1/apps/{application-id}/channels/voice",
    paginator = list()
  )
  input <- .pinpoint$get_voice_channel_input(ApplicationId = ApplicationId)
  output <- .pinpoint$get_voice_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$get_voice_channel <- pinpoint_get_voice_channel

#' Retrieves all the tags (keys and values) that are associated with an
#' application, campaign, or segment
#'
#' Retrieves all the tags (keys and values) that are associated with an
#' application, campaign, or segment.
#'
#' @usage
#' pinpoint_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the application, campaign, or segment.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_list_tags_for_resource
pinpoint_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .pinpoint$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .pinpoint$list_tags_for_resource_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$list_tags_for_resource <- pinpoint_list_tags_for_resource

#' Retrieves information about a phone number
#'
#' Retrieves information about a phone number.
#'
#' @usage
#' pinpoint_phone_number_validate(NumberValidateRequest)
#'
#' @param NumberValidateRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$phone_number_validate(
#'   NumberValidateRequest = list(
#'     IsoCountryCode = "string",
#'     PhoneNumber = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_phone_number_validate
pinpoint_phone_number_validate <- function(NumberValidateRequest) {
  op <- new_operation(
    name = "PhoneNumberValidate",
    http_method = "POST",
    http_path = "/v1/phone/number/validate",
    paginator = list()
  )
  input <- .pinpoint$phone_number_validate_input(NumberValidateRequest = NumberValidateRequest)
  output <- .pinpoint$phone_number_validate_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$phone_number_validate <- pinpoint_phone_number_validate

#' Creates a new event stream for an application or updates the settings of
#' an existing event stream for an application
#'
#' Creates a new event stream for an application or updates the settings of
#' an existing event stream for an application.
#'
#' @usage
#' pinpoint_put_event_stream(ApplicationId, WriteEventStream)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param WriteEventStream &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$put_event_stream(
#'   ApplicationId = "string",
#'   WriteEventStream = list(
#'     DestinationStreamArn = "string",
#'     RoleArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_put_event_stream
pinpoint_put_event_stream <- function(ApplicationId, WriteEventStream) {
  op <- new_operation(
    name = "PutEventStream",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/eventstream",
    paginator = list()
  )
  input <- .pinpoint$put_event_stream_input(ApplicationId = ApplicationId, WriteEventStream = WriteEventStream)
  output <- .pinpoint$put_event_stream_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$put_event_stream <- pinpoint_put_event_stream

#' Creates a new event to record for endpoints, or creates or updates
#' endpoint data that existing events are associated with
#'
#' Creates a new event to record for endpoints, or creates or updates
#' endpoint data that existing events are associated with.
#'
#' @usage
#' pinpoint_put_events(ApplicationId, EventsRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EventsRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$put_events(
#'   ApplicationId = "string",
#'   EventsRequest = list(
#'     BatchItem = list(
#'       list(
#'         Endpoint = list(
#'           Address = "string",
#'           Attributes = list(
#'             list(
#'               "string"
#'             )
#'           ),
#'           ChannelType = "GCM"|"APNS"|"APNS_SANDBOX"|"APNS_VOIP"|"APNS_VOIP_SANDBOX"|"ADM"|"SMS"|"VOICE"|"EMAIL"|"BAIDU"|"CUSTOM",
#'           Demographic = list(
#'             AppVersion = "string",
#'             Locale = "string",
#'             Make = "string",
#'             Model = "string",
#'             ModelVersion = "string",
#'             Platform = "string",
#'             PlatformVersion = "string",
#'             Timezone = "string"
#'           ),
#'           EffectiveDate = "string",
#'           EndpointStatus = "string",
#'           Location = list(
#'             City = "string",
#'             Country = "string",
#'             Latitude = 123.0,
#'             Longitude = 123.0,
#'             PostalCode = "string",
#'             Region = "string"
#'           ),
#'           Metrics = list(
#'             123.0
#'           ),
#'           OptOut = "string",
#'           RequestId = "string",
#'           User = list(
#'             UserAttributes = list(
#'               list(
#'                 "string"
#'               )
#'             ),
#'             UserId = "string"
#'           )
#'         ),
#'         Events = list(
#'           list(
#'             AppPackageName = "string",
#'             AppTitle = "string",
#'             AppVersionCode = "string",
#'             Attributes = list(
#'               "string"
#'             ),
#'             ClientSdkVersion = "string",
#'             EventType = "string",
#'             Metrics = list(
#'               123.0
#'             ),
#'             SdkName = "string",
#'             Session = list(
#'               Duration = 123,
#'               Id = "string",
#'               StartTimestamp = "string",
#'               StopTimestamp = "string"
#'             ),
#'             Timestamp = "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_put_events
pinpoint_put_events <- function(ApplicationId, EventsRequest) {
  op <- new_operation(
    name = "PutEvents",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/events",
    paginator = list()
  )
  input <- .pinpoint$put_events_input(ApplicationId = ApplicationId, EventsRequest = EventsRequest)
  output <- .pinpoint$put_events_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$put_events <- pinpoint_put_events

#' Removes one or more attributes, of the same attribute type, from all the
#' endpoints that are associated with an application
#'
#' Removes one or more attributes, of the same attribute type, from all the
#' endpoints that are associated with an application.
#'
#' @usage
#' pinpoint_remove_attributes(ApplicationId, AttributeType,
#'   UpdateAttributesRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param AttributeType &#91;required&#93;  <p>The type of attribute or attributes to remove. Valid values are:</p> <ul><li><p>endpoint-custom-attributes - Custom attributes that describe endpoints, such as the date when an associated user opted in or out of receiving communications from you through a specific type of channel.</p></li> <li><p>endpoint-custom-metrics - Custom metrics that your app reports to Amazon Pinpoint for endpoints, such as the number of app sessions or the number of items left in a cart.</p></li> <li><p>endpoint-user-attributes - Custom attributes that describe users, such as first name, last name, and age.</p></li></ul>
#' @param UpdateAttributesRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$remove_attributes(
#'   ApplicationId = "string",
#'   AttributeType = "string",
#'   UpdateAttributesRequest = list(
#'     Blacklist = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_remove_attributes
pinpoint_remove_attributes <- function(ApplicationId, AttributeType, UpdateAttributesRequest) {
  op <- new_operation(
    name = "RemoveAttributes",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/attributes/{attribute-type}",
    paginator = list()
  )
  input <- .pinpoint$remove_attributes_input(ApplicationId = ApplicationId, AttributeType = AttributeType, UpdateAttributesRequest = UpdateAttributesRequest)
  output <- .pinpoint$remove_attributes_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$remove_attributes <- pinpoint_remove_attributes

#' Creates and sends a direct message
#'
#' Creates and sends a direct message.
#'
#' @usage
#' pinpoint_send_messages(ApplicationId, MessageRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param MessageRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$send_messages(
#'   ApplicationId = "string",
#'   MessageRequest = list(
#'     Addresses = list(
#'       list(
#'         BodyOverride = "string",
#'         ChannelType = "GCM"|"APNS"|"APNS_SANDBOX"|"APNS_VOIP"|"APNS_VOIP_SANDBOX"|"ADM"|"SMS"|"VOICE"|"EMAIL"|"BAIDU"|"CUSTOM",
#'         Context = list(
#'           "string"
#'         ),
#'         RawContent = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         TitleOverride = "string"
#'       )
#'     ),
#'     Context = list(
#'       "string"
#'     ),
#'     Endpoints = list(
#'       list(
#'         BodyOverride = "string",
#'         Context = list(
#'           "string"
#'         ),
#'         RawContent = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         TitleOverride = "string"
#'       )
#'     ),
#'     MessageConfiguration = list(
#'       ADMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ConsolidationKey = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         ExpiresAfter = "string",
#'         IconReference = "string",
#'         ImageIconUrl = "string",
#'         ImageUrl = "string",
#'         MD5 = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         SmallImageIconUrl = "string",
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       APNSMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Badge = 123,
#'         Body = "string",
#'         Category = "string",
#'         CollapseId = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         MediaUrl = "string",
#'         PreferredAuthenticationMethod = "string",
#'         Priority = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         ThreadId = "string",
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       BaiduMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         IconReference = "string",
#'         ImageIconUrl = "string",
#'         ImageUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         SmallImageIconUrl = "string",
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       DefaultMessage = list(
#'         Body = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         )
#'       ),
#'       DefaultPushNotificationMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         SilentPush = TRUE|FALSE,
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       EmailMessage = list(
#'         Body = "string",
#'         FeedbackForwardingAddress = "string",
#'         FromAddress = "string",
#'         RawEmail = list(
#'           Data = raw
#'         ),
#'         ReplyToAddresses = list(
#'           "string"
#'         ),
#'         SimpleEmail = list(
#'           HtmlPart = list(
#'             Charset = "string",
#'             Data = "string"
#'           ),
#'           Subject = list(
#'             Charset = "string",
#'             Data = "string"
#'           ),
#'           TextPart = list(
#'             Charset = "string",
#'             Data = "string"
#'           )
#'         ),
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         )
#'       ),
#'       GCMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         CollapseKey = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         IconReference = "string",
#'         ImageIconUrl = "string",
#'         ImageUrl = "string",
#'         Priority = "string",
#'         RawContent = "string",
#'         RestrictedPackageName = "string",
#'         SilentPush = TRUE|FALSE,
#'         SmallImageIconUrl = "string",
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       SMSMessage = list(
#'         Body = "string",
#'         Keyword = "string",
#'         MessageType = "TRANSACTIONAL"|"PROMOTIONAL",
#'         OriginationNumber = "string",
#'         SenderId = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         )
#'       ),
#'       VoiceMessage = list(
#'         Body = "string",
#'         LanguageCode = "string",
#'         OriginationNumber = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         VoiceId = "string"
#'       )
#'     ),
#'     TraceId = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_send_messages
pinpoint_send_messages <- function(ApplicationId, MessageRequest) {
  op <- new_operation(
    name = "SendMessages",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/messages",
    paginator = list()
  )
  input <- .pinpoint$send_messages_input(ApplicationId = ApplicationId, MessageRequest = MessageRequest)
  output <- .pinpoint$send_messages_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$send_messages <- pinpoint_send_messages

#' Creates and sends a message to a list of users
#'
#' Creates and sends a message to a list of users.
#'
#' @usage
#' pinpoint_send_users_messages(ApplicationId, SendUsersMessageRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param SendUsersMessageRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$send_users_messages(
#'   ApplicationId = "string",
#'   SendUsersMessageRequest = list(
#'     Context = list(
#'       "string"
#'     ),
#'     MessageConfiguration = list(
#'       ADMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ConsolidationKey = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         ExpiresAfter = "string",
#'         IconReference = "string",
#'         ImageIconUrl = "string",
#'         ImageUrl = "string",
#'         MD5 = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         SmallImageIconUrl = "string",
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       APNSMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Badge = 123,
#'         Body = "string",
#'         Category = "string",
#'         CollapseId = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         MediaUrl = "string",
#'         PreferredAuthenticationMethod = "string",
#'         Priority = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         ThreadId = "string",
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       BaiduMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         IconReference = "string",
#'         ImageIconUrl = "string",
#'         ImageUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         SmallImageIconUrl = "string",
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       DefaultMessage = list(
#'         Body = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         )
#'       ),
#'       DefaultPushNotificationMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         SilentPush = TRUE|FALSE,
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       EmailMessage = list(
#'         Body = "string",
#'         FeedbackForwardingAddress = "string",
#'         FromAddress = "string",
#'         RawEmail = list(
#'           Data = raw
#'         ),
#'         ReplyToAddresses = list(
#'           "string"
#'         ),
#'         SimpleEmail = list(
#'           HtmlPart = list(
#'             Charset = "string",
#'             Data = "string"
#'           ),
#'           Subject = list(
#'             Charset = "string",
#'             Data = "string"
#'           ),
#'           TextPart = list(
#'             Charset = "string",
#'             Data = "string"
#'           )
#'         ),
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         )
#'       ),
#'       GCMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         CollapseKey = "string",
#'         Data = list(
#'           "string"
#'         ),
#'         IconReference = "string",
#'         ImageIconUrl = "string",
#'         ImageUrl = "string",
#'         Priority = "string",
#'         RawContent = "string",
#'         RestrictedPackageName = "string",
#'         SilentPush = TRUE|FALSE,
#'         SmallImageIconUrl = "string",
#'         Sound = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       SMSMessage = list(
#'         Body = "string",
#'         Keyword = "string",
#'         MessageType = "TRANSACTIONAL"|"PROMOTIONAL",
#'         OriginationNumber = "string",
#'         SenderId = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         )
#'       ),
#'       VoiceMessage = list(
#'         Body = "string",
#'         LanguageCode = "string",
#'         OriginationNumber = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         VoiceId = "string"
#'       )
#'     ),
#'     TraceId = "string",
#'     Users = list(
#'       list(
#'         BodyOverride = "string",
#'         Context = list(
#'           "string"
#'         ),
#'         RawContent = "string",
#'         Substitutions = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         TitleOverride = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_send_users_messages
pinpoint_send_users_messages <- function(ApplicationId, SendUsersMessageRequest) {
  op <- new_operation(
    name = "SendUsersMessages",
    http_method = "POST",
    http_path = "/v1/apps/{application-id}/users-messages",
    paginator = list()
  )
  input <- .pinpoint$send_users_messages_input(ApplicationId = ApplicationId, SendUsersMessageRequest = SendUsersMessageRequest)
  output <- .pinpoint$send_users_messages_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$send_users_messages <- pinpoint_send_users_messages

#' Adds one or more tags (keys and values) to an application, campaign, or
#' segment
#'
#' Adds one or more tags (keys and values) to an application, campaign, or
#' segment.
#'
#' @usage
#' pinpoint_tag_resource(ResourceArn, TagsModel)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the application, campaign, or segment.
#' @param TagsModel &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   TagsModel = list(
#'     tags = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_tag_resource
pinpoint_tag_resource <- function(ResourceArn, TagsModel) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .pinpoint$tag_resource_input(ResourceArn = ResourceArn, TagsModel = TagsModel)
  output <- .pinpoint$tag_resource_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$tag_resource <- pinpoint_tag_resource

#' Removes one or more tags (keys and values) from an application,
#' campaign, or segment
#'
#' Removes one or more tags (keys and values) from an application,
#' campaign, or segment.
#'
#' @usage
#' pinpoint_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the application, campaign, or segment.
#' @param TagKeys &#91;required&#93; The key of the tag to remove from the application, campaign, or segment.
#' To remove multiple tags, append the tagKeys parameter and argument for
#' each additional tag to remove, separated by an ampersand (&).
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_untag_resource
pinpoint_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/v1/tags/{resource-arn}",
    paginator = list()
  )
  input <- .pinpoint$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .pinpoint$untag_resource_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$untag_resource <- pinpoint_untag_resource

#' Updates the ADM channel settings for an application
#'
#' Updates the ADM channel settings for an application.
#'
#' @usage
#' pinpoint_update_adm_channel(ADMChannelRequest, ApplicationId)
#'
#' @param ADMChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$update_adm_channel(
#'   ADMChannelRequest = list(
#'     ClientId = "string",
#'     ClientSecret = "string",
#'     Enabled = TRUE|FALSE
#'   ),
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_adm_channel
pinpoint_update_adm_channel <- function(ADMChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateAdmChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/adm",
    paginator = list()
  )
  input <- .pinpoint$update_adm_channel_input(ADMChannelRequest = ADMChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_adm_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_adm_channel <- pinpoint_update_adm_channel

#' Updates the APNs channel settings for an application
#'
#' Updates the APNs channel settings for an application.
#'
#' @usage
#' pinpoint_update_apns_channel(APNSChannelRequest, ApplicationId)
#'
#' @param APNSChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$update_apns_channel(
#'   APNSChannelRequest = list(
#'     BundleId = "string",
#'     Certificate = "string",
#'     DefaultAuthenticationMethod = "string",
#'     Enabled = TRUE|FALSE,
#'     PrivateKey = "string",
#'     TeamId = "string",
#'     TokenKey = "string",
#'     TokenKeyId = "string"
#'   ),
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_apns_channel
pinpoint_update_apns_channel <- function(APNSChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateApnsChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/apns",
    paginator = list()
  )
  input <- .pinpoint$update_apns_channel_input(APNSChannelRequest = APNSChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_apns_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_apns_channel <- pinpoint_update_apns_channel

#' Updates the APNs sandbox channel settings for an application
#'
#' Updates the APNs sandbox channel settings for an application.
#'
#' @usage
#' pinpoint_update_apns_sandbox_channel(APNSSandboxChannelRequest,
#'   ApplicationId)
#'
#' @param APNSSandboxChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$update_apns_sandbox_channel(
#'   APNSSandboxChannelRequest = list(
#'     BundleId = "string",
#'     Certificate = "string",
#'     DefaultAuthenticationMethod = "string",
#'     Enabled = TRUE|FALSE,
#'     PrivateKey = "string",
#'     TeamId = "string",
#'     TokenKey = "string",
#'     TokenKeyId = "string"
#'   ),
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_apns_sandbox_channel
pinpoint_update_apns_sandbox_channel <- function(APNSSandboxChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateApnsSandboxChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/apns_sandbox",
    paginator = list()
  )
  input <- .pinpoint$update_apns_sandbox_channel_input(APNSSandboxChannelRequest = APNSSandboxChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_apns_sandbox_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_apns_sandbox_channel <- pinpoint_update_apns_sandbox_channel

#' Updates the APNs VoIP channel settings for an application
#'
#' Updates the APNs VoIP channel settings for an application.
#'
#' @usage
#' pinpoint_update_apns_voip_channel(APNSVoipChannelRequest, ApplicationId)
#'
#' @param APNSVoipChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$update_apns_voip_channel(
#'   APNSVoipChannelRequest = list(
#'     BundleId = "string",
#'     Certificate = "string",
#'     DefaultAuthenticationMethod = "string",
#'     Enabled = TRUE|FALSE,
#'     PrivateKey = "string",
#'     TeamId = "string",
#'     TokenKey = "string",
#'     TokenKeyId = "string"
#'   ),
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_apns_voip_channel
pinpoint_update_apns_voip_channel <- function(APNSVoipChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateApnsVoipChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/apns_voip",
    paginator = list()
  )
  input <- .pinpoint$update_apns_voip_channel_input(APNSVoipChannelRequest = APNSVoipChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_apns_voip_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_apns_voip_channel <- pinpoint_update_apns_voip_channel

#' Updates the settings for the APNs VoIP sandbox channel for an
#' application
#'
#' Updates the settings for the APNs VoIP sandbox channel for an
#' application.
#'
#' @usage
#' pinpoint_update_apns_voip_sandbox_channel(APNSVoipSandboxChannelRequest,
#'   ApplicationId)
#'
#' @param APNSVoipSandboxChannelRequest &#91;required&#93; 
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#'
#' @section Request syntax:
#' ```
#' svc$update_apns_voip_sandbox_channel(
#'   APNSVoipSandboxChannelRequest = list(
#'     BundleId = "string",
#'     Certificate = "string",
#'     DefaultAuthenticationMethod = "string",
#'     Enabled = TRUE|FALSE,
#'     PrivateKey = "string",
#'     TeamId = "string",
#'     TokenKey = "string",
#'     TokenKeyId = "string"
#'   ),
#'   ApplicationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_apns_voip_sandbox_channel
pinpoint_update_apns_voip_sandbox_channel <- function(APNSVoipSandboxChannelRequest, ApplicationId) {
  op <- new_operation(
    name = "UpdateApnsVoipSandboxChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/apns_voip_sandbox",
    paginator = list()
  )
  input <- .pinpoint$update_apns_voip_sandbox_channel_input(APNSVoipSandboxChannelRequest = APNSVoipSandboxChannelRequest, ApplicationId = ApplicationId)
  output <- .pinpoint$update_apns_voip_sandbox_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_apns_voip_sandbox_channel <- pinpoint_update_apns_voip_sandbox_channel

#' Updates the settings for an application
#'
#' Updates the settings for an application.
#'
#' @usage
#' pinpoint_update_application_settings(ApplicationId,
#'   WriteApplicationSettingsRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param WriteApplicationSettingsRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_application_settings(
#'   ApplicationId = "string",
#'   WriteApplicationSettingsRequest = list(
#'     CampaignHook = list(
#'       LambdaFunctionName = "string",
#'       Mode = "DELIVERY"|"FILTER",
#'       WebUrl = "string"
#'     ),
#'     CloudWatchMetricsEnabled = TRUE|FALSE,
#'     Limits = list(
#'       Daily = 123,
#'       MaximumDuration = 123,
#'       MessagesPerSecond = 123,
#'       Total = 123
#'     ),
#'     QuietTime = list(
#'       End = "string",
#'       Start = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_application_settings
pinpoint_update_application_settings <- function(ApplicationId, WriteApplicationSettingsRequest) {
  op <- new_operation(
    name = "UpdateApplicationSettings",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/settings",
    paginator = list()
  )
  input <- .pinpoint$update_application_settings_input(ApplicationId = ApplicationId, WriteApplicationSettingsRequest = WriteApplicationSettingsRequest)
  output <- .pinpoint$update_application_settings_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_application_settings <- pinpoint_update_application_settings

#' Updates the settings of the Baidu channel for an application
#'
#' Updates the settings of the Baidu channel for an application.
#'
#' @usage
#' pinpoint_update_baidu_channel(ApplicationId, BaiduChannelRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param BaiduChannelRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_baidu_channel(
#'   ApplicationId = "string",
#'   BaiduChannelRequest = list(
#'     ApiKey = "string",
#'     Enabled = TRUE|FALSE,
#'     SecretKey = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_baidu_channel
pinpoint_update_baidu_channel <- function(ApplicationId, BaiduChannelRequest) {
  op <- new_operation(
    name = "UpdateBaiduChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/baidu",
    paginator = list()
  )
  input <- .pinpoint$update_baidu_channel_input(ApplicationId = ApplicationId, BaiduChannelRequest = BaiduChannelRequest)
  output <- .pinpoint$update_baidu_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_baidu_channel <- pinpoint_update_baidu_channel

#' Updates the settings for a campaign
#'
#' Updates the settings for a campaign.
#'
#' @usage
#' pinpoint_update_campaign(ApplicationId, CampaignId,
#'   WriteCampaignRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param CampaignId &#91;required&#93; The unique identifier for the campaign.
#' @param WriteCampaignRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_campaign(
#'   ApplicationId = "string",
#'   CampaignId = "string",
#'   WriteCampaignRequest = list(
#'     AdditionalTreatments = list(
#'       list(
#'         MessageConfiguration = list(
#'           ADMMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           APNSMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           BaiduMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           DefaultMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           EmailMessage = list(
#'             Body = "string",
#'             FromAddress = "string",
#'             HtmlBody = "string",
#'             Title = "string"
#'           ),
#'           GCMMessage = list(
#'             Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'             Body = "string",
#'             ImageIconUrl = "string",
#'             ImageSmallIconUrl = "string",
#'             ImageUrl = "string",
#'             JsonBody = "string",
#'             MediaUrl = "string",
#'             RawContent = "string",
#'             SilentPush = TRUE|FALSE,
#'             TimeToLive = 123,
#'             Title = "string",
#'             Url = "string"
#'           ),
#'           SMSMessage = list(
#'             Body = "string",
#'             MessageType = "TRANSACTIONAL"|"PROMOTIONAL",
#'             SenderId = "string"
#'           )
#'         ),
#'         Schedule = list(
#'           EndTime = "string",
#'           EventFilter = list(
#'             Dimensions = list(
#'               Attributes = list(
#'                 list(
#'                   AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               EventType = list(
#'                 DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                 Values = list(
#'                   "string"
#'                 )
#'               ),
#'               Metrics = list(
#'                 list(
#'                   ComparisonOperator = "string",
#'                   Value = 123.0
#'                 )
#'               )
#'             ),
#'             FilterType = "SYSTEM"|"ENDPOINT"
#'           ),
#'           Frequency = "ONCE"|"HOURLY"|"DAILY"|"WEEKLY"|"MONTHLY"|"EVENT",
#'           IsLocalTime = TRUE|FALSE,
#'           QuietTime = list(
#'             End = "string",
#'             Start = "string"
#'           ),
#'           StartTime = "string",
#'           Timezone = "string"
#'         ),
#'         SizePercent = 123,
#'         TreatmentDescription = "string",
#'         TreatmentName = "string"
#'       )
#'     ),
#'     Description = "string",
#'     HoldoutPercent = 123,
#'     Hook = list(
#'       LambdaFunctionName = "string",
#'       Mode = "DELIVERY"|"FILTER",
#'       WebUrl = "string"
#'     ),
#'     IsPaused = TRUE|FALSE,
#'     Limits = list(
#'       Daily = 123,
#'       MaximumDuration = 123,
#'       MessagesPerSecond = 123,
#'       Total = 123
#'     ),
#'     MessageConfiguration = list(
#'       ADMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       APNSMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       BaiduMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       DefaultMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       EmailMessage = list(
#'         Body = "string",
#'         FromAddress = "string",
#'         HtmlBody = "string",
#'         Title = "string"
#'       ),
#'       GCMMessage = list(
#'         Action = "OPEN_APP"|"DEEP_LINK"|"URL",
#'         Body = "string",
#'         ImageIconUrl = "string",
#'         ImageSmallIconUrl = "string",
#'         ImageUrl = "string",
#'         JsonBody = "string",
#'         MediaUrl = "string",
#'         RawContent = "string",
#'         SilentPush = TRUE|FALSE,
#'         TimeToLive = 123,
#'         Title = "string",
#'         Url = "string"
#'       ),
#'       SMSMessage = list(
#'         Body = "string",
#'         MessageType = "TRANSACTIONAL"|"PROMOTIONAL",
#'         SenderId = "string"
#'       )
#'     ),
#'     Name = "string",
#'     Schedule = list(
#'       EndTime = "string",
#'       EventFilter = list(
#'         Dimensions = list(
#'           Attributes = list(
#'             list(
#'               AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'               Values = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           EventType = list(
#'             DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'             Values = list(
#'               "string"
#'             )
#'           ),
#'           Metrics = list(
#'             list(
#'               ComparisonOperator = "string",
#'               Value = 123.0
#'             )
#'           )
#'         ),
#'         FilterType = "SYSTEM"|"ENDPOINT"
#'       ),
#'       Frequency = "ONCE"|"HOURLY"|"DAILY"|"WEEKLY"|"MONTHLY"|"EVENT",
#'       IsLocalTime = TRUE|FALSE,
#'       QuietTime = list(
#'         End = "string",
#'         Start = "string"
#'       ),
#'       StartTime = "string",
#'       Timezone = "string"
#'     ),
#'     SegmentId = "string",
#'     SegmentVersion = 123,
#'     tags = list(
#'       "string"
#'     ),
#'     TreatmentDescription = "string",
#'     TreatmentName = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_campaign
pinpoint_update_campaign <- function(ApplicationId, CampaignId, WriteCampaignRequest) {
  op <- new_operation(
    name = "UpdateCampaign",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/campaigns/{campaign-id}",
    paginator = list()
  )
  input <- .pinpoint$update_campaign_input(ApplicationId = ApplicationId, CampaignId = CampaignId, WriteCampaignRequest = WriteCampaignRequest)
  output <- .pinpoint$update_campaign_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_campaign <- pinpoint_update_campaign

#' Updates the status and settings of the email channel for an application
#'
#' Updates the status and settings of the email channel for an application.
#'
#' @usage
#' pinpoint_update_email_channel(ApplicationId, EmailChannelRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EmailChannelRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_email_channel(
#'   ApplicationId = "string",
#'   EmailChannelRequest = list(
#'     ConfigurationSet = "string",
#'     Enabled = TRUE|FALSE,
#'     FromAddress = "string",
#'     Identity = "string",
#'     RoleArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_email_channel
pinpoint_update_email_channel <- function(ApplicationId, EmailChannelRequest) {
  op <- new_operation(
    name = "UpdateEmailChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/email",
    paginator = list()
  )
  input <- .pinpoint$update_email_channel_input(ApplicationId = ApplicationId, EmailChannelRequest = EmailChannelRequest)
  output <- .pinpoint$update_email_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_email_channel <- pinpoint_update_email_channel

#' Creates a new endpoint for an application or updates the settings and
#' attributes of an existing endpoint for an application
#'
#' Creates a new endpoint for an application or updates the settings and
#' attributes of an existing endpoint for an application. You can also use
#' this operation to define custom attributes (Attributes, Metrics, and
#' UserAttributes properties) for an endpoint.
#'
#' @usage
#' pinpoint_update_endpoint(ApplicationId, EndpointId, EndpointRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EndpointId &#91;required&#93; The unique identifier for the endpoint.
#' @param EndpointRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_endpoint(
#'   ApplicationId = "string",
#'   EndpointId = "string",
#'   EndpointRequest = list(
#'     Address = "string",
#'     Attributes = list(
#'       list(
#'         "string"
#'       )
#'     ),
#'     ChannelType = "GCM"|"APNS"|"APNS_SANDBOX"|"APNS_VOIP"|"APNS_VOIP_SANDBOX"|"ADM"|"SMS"|"VOICE"|"EMAIL"|"BAIDU"|"CUSTOM",
#'     Demographic = list(
#'       AppVersion = "string",
#'       Locale = "string",
#'       Make = "string",
#'       Model = "string",
#'       ModelVersion = "string",
#'       Platform = "string",
#'       PlatformVersion = "string",
#'       Timezone = "string"
#'     ),
#'     EffectiveDate = "string",
#'     EndpointStatus = "string",
#'     Location = list(
#'       City = "string",
#'       Country = "string",
#'       Latitude = 123.0,
#'       Longitude = 123.0,
#'       PostalCode = "string",
#'       Region = "string"
#'     ),
#'     Metrics = list(
#'       123.0
#'     ),
#'     OptOut = "string",
#'     RequestId = "string",
#'     User = list(
#'       UserAttributes = list(
#'         list(
#'           "string"
#'         )
#'       ),
#'       UserId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_endpoint
pinpoint_update_endpoint <- function(ApplicationId, EndpointId, EndpointRequest) {
  op <- new_operation(
    name = "UpdateEndpoint",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/endpoints/{endpoint-id}",
    paginator = list()
  )
  input <- .pinpoint$update_endpoint_input(ApplicationId = ApplicationId, EndpointId = EndpointId, EndpointRequest = EndpointRequest)
  output <- .pinpoint$update_endpoint_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_endpoint <- pinpoint_update_endpoint

#' Creates a new batch of endpoints for an application or updates the
#' settings and attributes of a batch of existing endpoints for an
#' application
#'
#'  <p>Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing endpoints for an application. You can also use this operation to define custom attributes (Attributes, Metrics, and UserAttributes properties) for a batch of endpoints.</p>
#'
#' @usage
#' pinpoint_update_endpoints_batch(ApplicationId, EndpointBatchRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param EndpointBatchRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_endpoints_batch(
#'   ApplicationId = "string",
#'   EndpointBatchRequest = list(
#'     Item = list(
#'       list(
#'         Address = "string",
#'         Attributes = list(
#'           list(
#'             "string"
#'           )
#'         ),
#'         ChannelType = "GCM"|"APNS"|"APNS_SANDBOX"|"APNS_VOIP"|"APNS_VOIP_SANDBOX"|"ADM"|"SMS"|"VOICE"|"EMAIL"|"BAIDU"|"CUSTOM",
#'         Demographic = list(
#'           AppVersion = "string",
#'           Locale = "string",
#'           Make = "string",
#'           Model = "string",
#'           ModelVersion = "string",
#'           Platform = "string",
#'           PlatformVersion = "string",
#'           Timezone = "string"
#'         ),
#'         EffectiveDate = "string",
#'         EndpointStatus = "string",
#'         Id = "string",
#'         Location = list(
#'           City = "string",
#'           Country = "string",
#'           Latitude = 123.0,
#'           Longitude = 123.0,
#'           PostalCode = "string",
#'           Region = "string"
#'         ),
#'         Metrics = list(
#'           123.0
#'         ),
#'         OptOut = "string",
#'         RequestId = "string",
#'         User = list(
#'           UserAttributes = list(
#'             list(
#'               "string"
#'             )
#'           ),
#'           UserId = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_endpoints_batch
pinpoint_update_endpoints_batch <- function(ApplicationId, EndpointBatchRequest) {
  op <- new_operation(
    name = "UpdateEndpointsBatch",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/endpoints",
    paginator = list()
  )
  input <- .pinpoint$update_endpoints_batch_input(ApplicationId = ApplicationId, EndpointBatchRequest = EndpointBatchRequest)
  output <- .pinpoint$update_endpoints_batch_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_endpoints_batch <- pinpoint_update_endpoints_batch

#' Updates the status and settings of the GCM channel for an application
#'
#' Updates the status and settings of the GCM channel for an application.
#'
#' @usage
#' pinpoint_update_gcm_channel(ApplicationId, GCMChannelRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param GCMChannelRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_gcm_channel(
#'   ApplicationId = "string",
#'   GCMChannelRequest = list(
#'     ApiKey = "string",
#'     Enabled = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_gcm_channel
pinpoint_update_gcm_channel <- function(ApplicationId, GCMChannelRequest) {
  op <- new_operation(
    name = "UpdateGcmChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/gcm",
    paginator = list()
  )
  input <- .pinpoint$update_gcm_channel_input(ApplicationId = ApplicationId, GCMChannelRequest = GCMChannelRequest)
  output <- .pinpoint$update_gcm_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_gcm_channel <- pinpoint_update_gcm_channel

#' Creates a new segment for an application or updates the configuration,
#' dimension, and other settings for an existing segment that's associated
#' with an application
#'
#' Creates a new segment for an application or updates the configuration,
#' dimension, and other settings for an existing segment that\'s associated
#' with an application.
#'
#' @usage
#' pinpoint_update_segment(ApplicationId, SegmentId, WriteSegmentRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param SegmentId &#91;required&#93; The unique identifier for the segment.
#' @param WriteSegmentRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_segment(
#'   ApplicationId = "string",
#'   SegmentId = "string",
#'   WriteSegmentRequest = list(
#'     Dimensions = list(
#'       Attributes = list(
#'         list(
#'           AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       Behavior = list(
#'         Recency = list(
#'           Duration = "HR_24"|"DAY_7"|"DAY_14"|"DAY_30",
#'           RecencyType = "ACTIVE"|"INACTIVE"
#'         )
#'       ),
#'       Demographic = list(
#'         AppVersion = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Channel = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         DeviceType = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Make = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Model = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         Platform = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       Location = list(
#'         Country = list(
#'           DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         ),
#'         GPSPoint = list(
#'           Coordinates = list(
#'             Latitude = 123.0,
#'             Longitude = 123.0
#'           ),
#'           RangeInKilometers = 123.0
#'         )
#'       ),
#'       Metrics = list(
#'         list(
#'           ComparisonOperator = "string",
#'           Value = 123.0
#'         )
#'       ),
#'       UserAttributes = list(
#'         list(
#'           AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       )
#'     ),
#'     Name = "string",
#'     SegmentGroups = list(
#'       Groups = list(
#'         list(
#'           Dimensions = list(
#'             list(
#'               Attributes = list(
#'                 list(
#'                   AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               Behavior = list(
#'                 Recency = list(
#'                   Duration = "HR_24"|"DAY_7"|"DAY_14"|"DAY_30",
#'                   RecencyType = "ACTIVE"|"INACTIVE"
#'                 )
#'               ),
#'               Demographic = list(
#'                 AppVersion = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Channel = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 DeviceType = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Make = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Model = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 Platform = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               Location = list(
#'                 Country = list(
#'                   DimensionType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 ),
#'                 GPSPoint = list(
#'                   Coordinates = list(
#'                     Latitude = 123.0,
#'                     Longitude = 123.0
#'                   ),
#'                   RangeInKilometers = 123.0
#'                 )
#'               ),
#'               Metrics = list(
#'                 list(
#'                   ComparisonOperator = "string",
#'                   Value = 123.0
#'                 )
#'               ),
#'               UserAttributes = list(
#'                 list(
#'                   AttributeType = "INCLUSIVE"|"EXCLUSIVE",
#'                   Values = list(
#'                     "string"
#'                   )
#'                 )
#'               )
#'             )
#'           ),
#'           SourceSegments = list(
#'             list(
#'               Id = "string",
#'               Version = 123
#'             )
#'           ),
#'           SourceType = "ALL"|"ANY"|"NONE",
#'           Type = "ALL"|"ANY"|"NONE"
#'         )
#'       ),
#'       Include = "ALL"|"ANY"|"NONE"
#'     ),
#'     tags = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_segment
pinpoint_update_segment <- function(ApplicationId, SegmentId, WriteSegmentRequest) {
  op <- new_operation(
    name = "UpdateSegment",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/segments/{segment-id}",
    paginator = list()
  )
  input <- .pinpoint$update_segment_input(ApplicationId = ApplicationId, SegmentId = SegmentId, WriteSegmentRequest = WriteSegmentRequest)
  output <- .pinpoint$update_segment_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_segment <- pinpoint_update_segment

#' Updates the status and settings of the SMS channel for an application
#'
#' Updates the status and settings of the SMS channel for an application.
#'
#' @usage
#' pinpoint_update_sms_channel(ApplicationId, SMSChannelRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param SMSChannelRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_sms_channel(
#'   ApplicationId = "string",
#'   SMSChannelRequest = list(
#'     Enabled = TRUE|FALSE,
#'     SenderId = "string",
#'     ShortCode = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_sms_channel
pinpoint_update_sms_channel <- function(ApplicationId, SMSChannelRequest) {
  op <- new_operation(
    name = "UpdateSmsChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/sms",
    paginator = list()
  )
  input <- .pinpoint$update_sms_channel_input(ApplicationId = ApplicationId, SMSChannelRequest = SMSChannelRequest)
  output <- .pinpoint$update_sms_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_sms_channel <- pinpoint_update_sms_channel

#' Updates the status and settings of the voice channel for an application
#'
#' Updates the status and settings of the voice channel for an application.
#'
#' @usage
#' pinpoint_update_voice_channel(ApplicationId, VoiceChannelRequest)
#'
#' @param ApplicationId &#91;required&#93; The unique identifier for the application. This identifier is displayed
#' as the **Project ID** on the Amazon Pinpoint console.
#' @param VoiceChannelRequest &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$update_voice_channel(
#'   ApplicationId = "string",
#'   VoiceChannelRequest = list(
#'     Enabled = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname pinpoint_update_voice_channel
pinpoint_update_voice_channel <- function(ApplicationId, VoiceChannelRequest) {
  op <- new_operation(
    name = "UpdateVoiceChannel",
    http_method = "PUT",
    http_path = "/v1/apps/{application-id}/channels/voice",
    paginator = list()
  )
  input <- .pinpoint$update_voice_channel_input(ApplicationId = ApplicationId, VoiceChannelRequest = VoiceChannelRequest)
  output <- .pinpoint$update_voice_channel_output()
  svc <- .pinpoint$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.pinpoint$operations$update_voice_channel <- pinpoint_update_voice_channel
