% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_delete_user}
\alias{connect_delete_user}
\title{Deletes a user account from the specified Amazon Connect instance}
\usage{
connect_delete_user(InstanceId, UserId)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{UserId}{[required] The identifier of the user.}
}
\value{
An empty list.
}
\description{
Deletes a user account from the specified Amazon Connect instance.

For information about what happens to a user's data when their account
is deleted, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html}{Delete Users from Your Amazon Connect Instance}
in the \emph{Amazon Connect Administrator Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_user(
  InstanceId = "string",
  UserId = "string"
)
}
}

\keyword{internal}
