% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_update_recommender_configuration}
\alias{pinpoint_update_recommender_configuration}
\title{Updates an Amazon Pinpoint configuration for a recommender model}
\usage{
pinpoint_update_recommender_configuration(RecommenderId,
  UpdateRecommenderConfiguration)
}
\arguments{
\item{RecommenderId}{[required] The unique identifier for the recommender model configuration. This
identifier is displayed as the \strong{Recommender ID} on the Amazon Pinpoint
console.}

\item{UpdateRecommenderConfiguration}{[required]}
}
\value{
A list with the following syntax:\preformatted{list(
  RecommenderConfigurationResponse = list(
    Attributes = list(
      "string"
    ),
    CreationDate = "string",
    Description = "string",
    Id = "string",
    LastModifiedDate = "string",
    Name = "string",
    RecommendationProviderIdType = "string",
    RecommendationProviderRoleArn = "string",
    RecommendationProviderUri = "string",
    RecommendationTransformerUri = "string",
    RecommendationsDisplayName = "string",
    RecommendationsPerMessage = 123
  )
)
}
}
\description{
Updates an Amazon Pinpoint configuration for a recommender model.
}
\section{Request syntax}{
\preformatted{svc$update_recommender_configuration(
  RecommenderId = "string",
  UpdateRecommenderConfiguration = list(
    Attributes = list(
      "string"
    ),
    Description = "string",
    Name = "string",
    RecommendationProviderIdType = "string",
    RecommendationProviderRoleArn = "string",
    RecommendationProviderUri = "string",
    RecommendationTransformerUri = "string",
    RecommendationsDisplayName = "string",
    RecommendationsPerMessage = 123
  )
)
}
}

\keyword{internal}
