% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_get_application_settings}
\alias{pinpoint_get_application_settings}
\title{Retrieves information about the settings for an application}
\usage{
pinpoint_get_application_settings(ApplicationId)
}
\arguments{
\item{ApplicationId}{[required] The unique identifier for the application. This identifier is displayed
as the \strong{Project ID} on the Amazon Pinpoint console.}
}
\value{
A list with the following syntax:\preformatted{list(
  ApplicationSettingsResource = list(
    ApplicationId = "string",
    CampaignHook = list(
      LambdaFunctionName = "string",
      Mode = "DELIVERY"|"FILTER",
      WebUrl = "string"
    ),
    LastModifiedDate = "string",
    Limits = list(
      Daily = 123,
      MaximumDuration = 123,
      MessagesPerSecond = 123,
      Total = 123
    ),
    QuietTime = list(
      End = "string",
      Start = "string"
    )
  )
)
}
}
\description{
Retrieves information about the settings for an application.
}
\section{Request syntax}{
\preformatted{svc$get_application_settings(
  ApplicationId = "string"
)
}
}

\keyword{internal}
