% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_set_identity_mail_from_domain}
\alias{ses_set_identity_mail_from_domain}
\title{Enables or disables the custom MAIL FROM domain setup for a verified
identity (an email address or a domain)}
\usage{
ses_set_identity_mail_from_domain(Identity, MailFromDomain,
  BehaviorOnMXFailure)
}
\arguments{
\item{Identity}{[required] The verified identity for which you want to enable or disable the
specified custom MAIL FROM domain.}

\item{MailFromDomain}{The custom MAIL FROM domain that you want the verified identity to use.
The MAIL FROM domain must 1) be a subdomain of the verified identity, 2)
not be used in a "From" address if the MAIL FROM domain is the
destination of email feedback forwarding (for more information, see the
\href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mail-from.html}{Amazon SES Developer Guide}),
and 3) not be used to receive emails. A value of \code{null} disables the
custom MAIL FROM setting for the identity.}

\item{BehaviorOnMXFailure}{The action that you want Amazon SES to take if it cannot successfully
read the required MX record when you send an email. If you choose
\code{UseDefaultValue}, Amazon SES will use amazonses.com (or a subdomain of
that) as the MAIL FROM domain. If you choose \code{RejectMessage}, Amazon SES
will return a \code{MailFromDomainNotVerified} error and not send the email.

The action specified in \code{BehaviorOnMXFailure} is taken when the custom
MAIL FROM domain setup is in the \code{Pending}, \code{Failed}, and
\code{TemporaryFailure} states.}
}
\description{
Enables or disables the custom MAIL FROM domain setup for a verified
identity (an email address or a domain).

To send emails using the specified MAIL FROM domain, you must add an MX
record to your MAIL FROM domain's DNS settings. If you want your emails
to pass Sender Policy Framework (SPF) checks, you must also add or
update an SPF record. For more information, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$set_identity_mail_from_domain(
  Identity = "string",
  MailFromDomain = "string",
  BehaviorOnMXFailure = "UseDefaultValue"|"RejectMessage"
)
}
}

\examples{
\dontrun{
# The following example configures Amazon SES to use a custom MAIL FROM
# domain for an identity:
svc$set_identity_mail_from_domain(
  BehaviorOnMXFailure = "UseDefaultValue",
  Identity = "user@example.com",
  MailFromDomain = "bounces.example.com"
)
}

}
\keyword{internal}
