% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paymentcryptographydataplane_operations.R
\name{paymentcryptographydataplane_generate_mac}
\alias{paymentcryptographydataplane_generate_mac}
\title{Generates a Message Authentication Code (MAC) cryptogram within Amazon
Web Services Payment Cryptography}
\usage{
paymentcryptographydataplane_generate_mac(
  KeyIdentifier,
  MessageData,
  GenerationAttributes,
  MacLength = NULL
)
}
\arguments{
\item{KeyIdentifier}{[required] The \code{keyARN} of the MAC generation encryption key.}

\item{MessageData}{[required] The data for which a MAC is under generation. This value must be
hexBinary.}

\item{GenerationAttributes}{[required] The attributes and data values to use for MAC generation within Amazon
Web Services Payment Cryptography.}

\item{MacLength}{The length of a MAC under generation.}
}
\description{
Generates a Message Authentication Code (MAC) cryptogram within Amazon Web Services Payment Cryptography.

See \url{https://www.paws-r-sdk.com/docs/paymentcryptographydataplane_generate_mac/} for full documentation.
}
\keyword{internal}
