% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketplaceentitlementservice_operations.R
\name{marketplaceentitlementservice_get_entitlements}
\alias{marketplaceentitlementservice_get_entitlements}
\title{GetEntitlements retrieves entitlement values for a given product}
\usage{
marketplaceentitlementservice_get_entitlements(
  ProductCode,
  Filter = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{ProductCode}{[required] Product code is used to uniquely identify a product in AWS Marketplace.
The product code will be provided by AWS Marketplace when the product
listing is created.}

\item{Filter}{Filter is used to return entitlements for a specific customer or for a
specific dimension. Filters are described as keys mapped to a lists of
values. Filtered requests are \emph{unioned} for each value in the value
list, and then \emph{intersected} for each filter key.}

\item{NextToken}{For paginated calls to GetEntitlements, pass the NextToken from the
previous GetEntitlementsResult.}

\item{MaxResults}{The maximum number of items to retrieve from the GetEntitlements
operation. For pagination, use the NextToken field in subsequent calls
to GetEntitlements.}
}
\description{
GetEntitlements retrieves entitlement values for a given product. The results can be filtered based on customer identifier or product dimensions.

See \url{https://www.paws-r-sdk.com/docs/marketplaceentitlementservice_get_entitlements/} for full documentation.
}
\keyword{internal}
