% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_usage_forecast}
\alias{costexplorer_get_usage_forecast}
\title{Retrieves a forecast for how much Amazon Web Services predicts that you
will use over the forecast time period that you select, based on your
past usage}
\usage{
costexplorer_get_usage_forecast(
  TimePeriod,
  Metric,
  Granularity,
  Filter = NULL,
  PredictionIntervalLevel = NULL
)
}
\arguments{
\item{TimePeriod}{[required] The start and end dates of the period that you want to retrieve usage
forecast for. The start date is included in the period, but the end date
isn't included in the period. For example, if \code{start} is \code{2017-01-01}
and \code{end} is \code{2017-05-01}, then the cost and usage data is retrieved
from \code{2017-01-01} up to and including \code{2017-04-30} but not including
\code{2017-05-01}. The start date must be equal to or later than the current
date to avoid a validation error.}

\item{Metric}{[required] Which metric Cost Explorer uses to create your forecast.

Valid values for a
\code{\link[=costexplorer_get_usage_forecast]{get_usage_forecast}} call are the
following:
\itemize{
\item USAGE_QUANTITY
\item NORMALIZED_USAGE_AMOUNT
}}

\item{Granularity}{[required] How granular you want the forecast to be. You can get 3 months of
\code{DAILY} forecasts or 12 months of \code{MONTHLY} forecasts.

The \code{\link[=costexplorer_get_usage_forecast]{get_usage_forecast}} operation
supports only \code{DAILY} and \code{MONTHLY} granularities.}

\item{Filter}{The filters that you want to use to filter your forecast. The
\code{\link[=costexplorer_get_usage_forecast]{get_usage_forecast}} API supports
filtering by the following dimensions:
\itemize{
\item \code{AZ}
\item \code{INSTANCE_TYPE}
\item \code{LINKED_ACCOUNT}
\item \code{LINKED_ACCOUNT_NAME}
\item \code{OPERATION}
\item \code{PURCHASE_TYPE}
\item \code{REGION}
\item \code{SERVICE}
\item \code{USAGE_TYPE}
\item \code{USAGE_TYPE_GROUP}
\item \code{RECORD_TYPE}
\item \code{OPERATING_SYSTEM}
\item \code{TENANCY}
\item \code{SCOPE}
\item \code{PLATFORM}
\item \code{SUBSCRIPTION_ID}
\item \code{LEGAL_ENTITY_NAME}
\item \code{DEPLOYMENT_OPTION}
\item \code{DATABASE_ENGINE}
\item \code{INSTANCE_TYPE_FAMILY}
\item \code{BILLING_ENTITY}
\item \code{RESERVATION_ID}
\item \code{SAVINGS_PLAN_ARN}
}}

\item{PredictionIntervalLevel}{Amazon Web Services Cost Explorer always returns the mean forecast as a
single point. You can request a prediction interval around the mean by
specifying a confidence level. The higher the confidence level, the more
confident Cost Explorer is about the actual value falling in the
prediction interval. Higher confidence levels result in wider prediction
intervals.}
}
\description{
Retrieves a forecast for how much Amazon Web Services predicts that you will use over the forecast time period that you select, based on your past usage.

See \url{https://www.paws-r-sdk.com/docs/costexplorer_get_usage_forecast/} for full documentation.
}
\keyword{internal}
