# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Price List Service
#'
#' @description
#' Amazon Web Services Price List API is a centralized and convenient way
#' to programmatically query Amazon Web Services for services, products,
#' and pricing information. The Amazon Web Services Price List uses
#' standardized product attributes such as `Location`, `Storage Class`, and
#' `Operating System`, and provides prices at the SKU level. You can use
#' the Amazon Web Services Price List to build cost control and scenario
#' planning tools, reconcile billing data, forecast future spend for
#' budgeting purposes, and provide cost benefit analysis that compare your
#' internal workloads with Amazon Web Services.
#' 
#' Use `GetServices` without a service code to retrieve the service codes
#' for all AWS services, then `GetServices` with a service code to retrieve
#' the attribute names for that service. After you have the service code
#' and attribute names, you can use
#' [`get_attribute_values`][pricing_get_attribute_values] to see what
#' values are available for an attribute. With the service code and an
#' attribute name and value, you can use
#' [`get_products`][pricing_get_products] to find specific products that
#' you're interested in, such as an `AmazonEC2` instance, with a
#' `Provisioned IOPS` `volumeType`.
#' 
#' Service Endpoint
#' 
#' Amazon Web Services Price List service API provides the following two
#' endpoints:
#' 
#' -   https://api.pricing.us-east-1.amazonaws.com
#' 
#' -   https://api.pricing.ap-south-1.amazonaws.com
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- pricing(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- pricing()
#' # Retrieves the service for the given Service Code.
#' svc$describe_services(
#'   FormatVersion = "aws_v1",
#'   MaxResults = 1L,
#'   ServiceCode = "AmazonEC2"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=pricing_describe_services]{describe_services} \tab Returns the metadata for one service or a list of the metadata for all services\cr
#'  \link[=pricing_get_attribute_values]{get_attribute_values} \tab Returns a list of attribute values\cr
#'  \link[=pricing_get_products]{get_products} \tab Returns a list of all products that match the filter criteria
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname pricing
#' @export
pricing <- function(config = list()) {
  svc <- .pricing$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.pricing <- list()

.pricing$operations <- list()

.pricing$metadata <- list(
  service_name = "api.pricing",
  endpoints = list("*" = list(endpoint = "api.pricing.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "api.pricing.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "api.pricing.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "api.pricing.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Pricing",
  api_version = "2017-10-15",
  signing_name = "pricing",
  json_version = "1.1",
  target_prefix = "AWSPriceListService"
)

.pricing$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.pricing$metadata, handlers, config)
}
