% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_savings_plans_purchase_recommendation}
\alias{costexplorer_get_savings_plans_purchase_recommendation}
\title{Retrieves your request parameters, Savings Plan Recommendations Summary
and Details}
\usage{
costexplorer_get_savings_plans_purchase_recommendation(SavingsPlansType,
  TermInYears, PaymentOption, NextPageToken, PageSize,
  LookbackPeriodInDays)
}
\arguments{
\item{SavingsPlansType}{[required] The Savings Plans recommendation type requested.}

\item{TermInYears}{[required] The savings plan recommendation term used to generated these
recommendations.}

\item{PaymentOption}{[required] The payment option used to generate these recommendations.}

\item{NextPageToken}{The token to retrieve the next set of results. Amazon Web Services
provides the token when the response from a previous call has more
results than the maximum page size.}

\item{PageSize}{The number of recommendations that you want returned in a single
response object.}

\item{LookbackPeriodInDays}{[required] The lookback period used to generate the recommendation.}
}
\description{
Retrieves your request parameters, Savings Plan Recommendations Summary
and Details.
}
\section{Request syntax}{
\preformatted{svc$get_savings_plans_purchase_recommendation(
  SavingsPlansType = "COMPUTE_SP"|"EC2_INSTANCE_SP",
  TermInYears = "ONE_YEAR"|"THREE_YEARS",
  PaymentOption = "NO_UPFRONT"|"PARTIAL_UPFRONT"|"ALL_UPFRONT"|"LIGHT_UTILIZATION"|"MEDIUM_UTILIZATION"|"HEAVY_UTILIZATION",
  NextPageToken = "string",
  PageSize = 123,
  LookbackPeriodInDays = "SEVEN_DAYS"|"THIRTY_DAYS"|"SIXTY_DAYS"
)
}
}

\keyword{internal}
