% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketplacecommerceanalytics_service.R
\name{marketplacecommerceanalytics}
\alias{marketplacecommerceanalytics}
\title{AWS Marketplace Commerce Analytics}
\usage{
marketplacecommerceanalytics(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Provides AWS Marketplace business intelligence data on-demand.
}
\section{Service syntax}{
\preformatted{svc <- marketplacecommerceanalytics(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=marketplacecommerceanalytics_generate_data_set]{generate_data_set} \tab Given a data set type and data set publication date, asynchronously publishes the requested data set to the specified S3 bucket and notifies the specified SNS topic once the data is available\cr
\link[=marketplacecommerceanalytics_start_support_data_export]{start_support_data_export} \tab Given a data set type and a from date, asynchronously publishes the requested customer support data to the specified S3 bucket and notifies the specified SNS topic once the data is available
}
}

\examples{
\dontrun{
svc <- marketplacecommerceanalytics()
svc$generate_data_set(
  Foo = 123
)
}

}
