% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_cost_forecast}
\alias{costexplorer_get_cost_forecast}
\title{Retrieves a forecast for how much Amazon Web Services predicts that you
will spend over the forecast time period that you select, based on your
past costs}
\usage{
costexplorer_get_cost_forecast(TimePeriod, Metric, Granularity, Filter,
  PredictionIntervalLevel)
}
\arguments{
\item{TimePeriod}{[required] The period of time that you want the forecast to cover.}

\item{Metric}{[required] Which metric Cost Explorer uses to create your forecast. For more
information about blended and unblended rates, see \href{https://aws.amazon.com/premiumsupport/knowledge-center/blended-rates-intro/}{Why does the "blended" annotation appear on some line items in my bill?}.

Valid values for a \code{GetCostForecast} call are the following:
\itemize{
\item AmortizedCost
\item BlendedCost
\item NetAmortizedCost
\item NetUnblendedCost
\item UnblendedCost
}}

\item{Granularity}{[required] How granular you want the forecast to be. You can get 3 months of
\code{DAILY} forecasts or 12 months of \code{MONTHLY} forecasts.

The \code{GetCostForecast} operation supports only \code{DAILY} and \code{MONTHLY}
granularities.}

\item{Filter}{The filters that you want to use to filter your forecast. Cost Explorer
API supports all of the Cost Explorer filters.}

\item{PredictionIntervalLevel}{Cost Explorer always returns the mean forecast as a single point. You
can request a prediction interval around the mean by specifying a
confidence level. The higher the confidence level, the more confident
Cost Explorer is about the actual value falling in the prediction
interval. Higher confidence levels result in wider prediction intervals.}
}
\description{
Retrieves a forecast for how much Amazon Web Services predicts that you
will spend over the forecast time period that you select, based on your
past costs.
}
\section{Request syntax}{
\preformatted{svc$get_cost_forecast(
  TimePeriod = list(
    Start = "string",
    End = "string"
  ),
  Metric = "BLENDED_COST"|"UNBLENDED_COST"|"AMORTIZED_COST"|"NET_UNBLENDED_COST"|"NET_AMORTIZED_COST"|"USAGE_QUANTITY"|"NORMALIZED_USAGE_AMOUNT",
  Granularity = "DAILY"|"MONTHLY"|"HOURLY",
  Filter = list(
    Or = list(
      list()
    ),
    And = list(
      list()
    ),
    Not = list(),
    Dimensions = list(
      Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID",
      Values = list(
        "string"
      )
    ),
    Tags = list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  PredictionIntervalLevel = 123
)
}
}

\keyword{internal}
