% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_associate_access_policy}
\alias{eks_associate_access_policy}
\title{Associates an access policy and its scope to an access entry}
\usage{
eks_associate_access_policy(clusterName, principalArn, policyArn, accessScope)
}
\arguments{
\item{clusterName}{[required] The name of your cluster.}

\item{principalArn}{[required] The Amazon Resource Name (ARN) of the IAM user or role for the
\code{AccessEntry} that you're associating the access policy to.}

\item{policyArn}{[required] The ARN of the \code{AccessPolicy} that you're associating. For a list of
ARNs, use \code{\link[=eks_list_access_policies]{list_access_policies}}.}

\item{accessScope}{[required] The scope for the \code{AccessPolicy}. You can scope access policies to an
entire cluster or to specific Kubernetes namespaces.}
}
\description{
Associates an access policy and its scope to an access entry. For more information about associating access policies, see \href{https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html}{Associating and disassociating access policies to and from access entries} in the \emph{Amazon EKS User Guide}.

See \url{https://www.paws-r-sdk.com/docs/eks_associate_access_policy/} for full documentation.
}
\keyword{internal}
