% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_update_cluster_settings}
\alias{ecs_update_cluster_settings}
\title{Modifies the settings to use for a cluster}
\usage{
ecs_update_cluster_settings(cluster, settings)
}
\arguments{
\item{cluster}{[required] The name of the cluster to modify the settings for.}

\item{settings}{[required] The setting to use by default for a cluster. This parameter is used to
turn on CloudWatch Container Insights for a cluster. If this value is
specified, it overrides the \code{containerInsights} value set with
\code{\link[=ecs_put_account_setting]{put_account_setting}} or
\code{\link[=ecs_put_account_setting_default]{put_account_setting_default}}.

Currently, if you delete an existing cluster that does not have
Container Insights turned on, and then create a new cluster with the
same name with Container Insights tuned on, Container Insights will not
actually be turned on. If you want to preserve the same name for your
existing cluster and turn on Container Insights, you must wait 7 days
before you can re-create it.}
}
\description{
Modifies the settings to use for a cluster.

See \url{https://www.paws-r-sdk.com/docs/ecs_update_cluster_settings/} for full documentation.
}
\keyword{internal}
