% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_list_account_settings}
\alias{ecs_list_account_settings}
\title{Lists the account settings for a specified principal}
\usage{
ecs_list_account_settings(
  name = NULL,
  value = NULL,
  principalArn = NULL,
  effectiveSettings = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{name}{The name of the account setting you want to list the settings for.}

\item{value}{The value of the account settings to filter results with. You must also
specify an account setting name to use this parameter.}

\item{principalArn}{The ARN of the principal, which can be a user, role, or the root user.
If this field is omitted, the account settings are listed only for the
authenticated user.

Federated users assume the account setting of the root user and can't
have explicit account settings set for them.}

\item{effectiveSettings}{Determines whether to return the effective settings. If \code{true}, the
account settings for the root user or the default setting for the
\code{principalArn} are returned. If \code{false}, the account settings for the
\code{principalArn} are returned if they're set. Otherwise, no account
settings are returned.}

\item{nextToken}{The \code{nextToken} value returned from a
\code{\link[=ecs_list_account_settings]{list_account_settings}} request indicating
that more results are available to fulfill the request and further calls
will be needed. If \code{maxResults} was provided, it's possible the number
of results to be fewer than \code{maxResults}.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.}

\item{maxResults}{The maximum number of account setting results returned by
\code{\link[=ecs_list_account_settings]{list_account_settings}} in paginated
output. When this parameter is used,
\code{\link[=ecs_list_account_settings]{list_account_settings}} only returns
\code{maxResults} results in a single page along with a \code{nextToken} response
element. The remaining results of the initial request can be seen by
sending another \code{\link[=ecs_list_account_settings]{list_account_settings}}
request with the returned \code{nextToken} value. This value can be between 1
and 10. If this parameter isn't used, then
\code{\link[=ecs_list_account_settings]{list_account_settings}} returns up to 10
results and a \code{nextToken} value if applicable.}
}
\description{
Lists the account settings for a specified principal.

See \url{https://www.paws-r-sdk.com/docs/ecs_list_account_settings/} for full documentation.
}
\keyword{internal}
