% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_instance_cpu_options}
\alias{ec2_modify_instance_cpu_options}
\title{By default, all vCPUs for the instance type are active when you launch
an instance}
\usage{
ec2_modify_instance_cpu_options(
  InstanceId,
  CoreCount,
  ThreadsPerCore,
  DryRun = NULL
)
}
\arguments{
\item{InstanceId}{[required] The ID of the instance to update.}

\item{CoreCount}{[required] The number of CPU cores to activate for the specified instance.}

\item{ThreadsPerCore}{[required] The number of threads to run for each CPU core.}

\item{DryRun}{Checks whether you have the required permissions for the operation,
without actually making the request, and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
By default, all vCPUs for the instance type are active when you launch an instance. When you configure the number of active vCPUs for the instance, it can help you save on licensing costs and optimize performance. The base cost of the instance remains unchanged.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_instance_cpu_options/} for full documentation.
}
\keyword{internal}
