% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_groups_for_capacity_reservation}
\alias{ec2_get_groups_for_capacity_reservation}
\title{Lists the resource groups to which a Capacity Reservation has been added}
\usage{
ec2_get_groups_for_capacity_reservation(
  CapacityReservationId,
  NextToken = NULL,
  MaxResults = NULL,
  DryRun = NULL
)
}
\arguments{
\item{CapacityReservationId}{[required] The ID of the Capacity Reservation. If you specify a Capacity
Reservation that is shared with you, the operation returns only Capacity
Reservation groups that you own.}

\item{NextToken}{The token to use to retrieve the next page of results.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Lists the resource groups to which a Capacity Reservation has been added.

See \url{https://www.paws-r-sdk.com/docs/ec2_get_groups_for_capacity_reservation/} for full documentation.
}
\keyword{internal}
