% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_vpc_endpoint_associations}
\alias{ec2_describe_vpc_endpoint_associations}
\title{Describes the VPC resources, VPC endpoint services, Amazon Lattice
services, or service networks associated with the VPC endpoint}
\usage{
ec2_describe_vpc_endpoint_associations(
  DryRun = NULL,
  VpcEndpointIds = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcEndpointIds}{The IDs of the VPC endpoints.}

\item{Filters}{The filters.
\itemize{
\item \code{vpc-endpoint-id} - The ID of the VPC endpoint.
\item \code{associated-resource-accessibility} - The association state. When
the state is \code{accessible}, it returns \code{AVAILABLE}. When the state is
\code{inaccessible}, it returns \code{PENDING} or \code{FAILED}.
\item \code{association-id} - The ID of the VPC endpoint association.
\item \code{associated-resource-id} - The ID of the associated resource
configuration.
\item \code{service-network-arn} - The Amazon Resource Name (ARN) of the
associated service network. Only VPC endpoints of type service
network will be returned.
\item \code{resource-configuration-group-arn} - The Amazon Resource Name (ARN)
of the resource configuration of type GROUP.
\item \code{service-network-resource-association-id} - The ID of the
association.
}}

\item{MaxResults}{The maximum page size.}

\item{NextToken}{The pagination token.}
}
\description{
Describes the VPC resources, VPC endpoint services, Amazon Lattice services, or service networks associated with the VPC endpoint.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_vpc_endpoint_associations/} for full documentation.
}
\keyword{internal}
