% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_list_pod_identity_associations}
\alias{eks_list_pod_identity_associations}
\title{List the EKS Pod Identity associations in a cluster}
\usage{
eks_list_pod_identity_associations(
  clusterName,
  namespace = NULL,
  serviceAccount = NULL,
  maxResults = NULL,
  nextToken = NULL
)
}
\arguments{
\item{clusterName}{[required] The name of the cluster that the associations are in.}

\item{namespace}{The name of the Kubernetes namespace inside the cluster that the
associations are in.}

\item{serviceAccount}{The name of the Kubernetes service account that the associations use.}

\item{maxResults}{The maximum number of EKS Pod Identity association results returned by
\code{\link[=eks_list_pod_identity_associations]{list_pod_identity_associations}}
in paginated output. When you use this parameter,
\code{\link[=eks_list_pod_identity_associations]{list_pod_identity_associations}}
returns only \code{maxResults} results in a single page along with a
\code{nextToken} response element. You can see the remaining results of the
initial request by sending another
\code{\link[=eks_list_pod_identity_associations]{list_pod_identity_associations}}
request with the returned \code{nextToken} value. This value can be between 1
and 100. If you don't use this parameter,
\code{\link[=eks_list_pod_identity_associations]{list_pod_identity_associations}}
returns up to 100 results and a \code{nextToken} value if applicable.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{\link[=eks_list_updates]{list_updates}} request where \code{maxResults} was used
and the results exceeded the value of that parameter. Pagination
continues from the end of the previous results that returned the
\code{nextToken} value.

This token should be treated as an opaque identifier that is used only
to retrieve the next items in a list and not for other programmatic
purposes.}
}
\description{
List the EKS Pod Identity associations in a cluster. You can filter the list by the namespace that the association is in or the service account that the association uses.

See \url{https://www.paws-r-sdk.com/docs/eks_list_pod_identity_associations/} for full documentation.
}
\keyword{internal}
