% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_vpc_peering_connections}
\alias{ec2_describe_vpc_peering_connections}
\title{Describes your VPC peering connections}
\usage{
ec2_describe_vpc_peering_connections(
  Filters = NULL,
  DryRun = NULL,
  VpcPeeringConnectionIds = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{Filters}{The filters.
\itemize{
\item \code{accepter-vpc-info.cidr-block} - The IPv4 CIDR block of the accepter
VPC.
\item \code{accepter-vpc-info.owner-id} - The ID of the Amazon Web Services
account that owns the accepter VPC.
\item \code{accepter-vpc-info.vpc-id} - The ID of the accepter VPC.
\item \code{expiration-time} - The expiration date and time for the VPC peering
connection.
\item \code{requester-vpc-info.cidr-block} - The IPv4 CIDR block of the
requester's VPC.
\item \code{requester-vpc-info.owner-id} - The ID of the Amazon Web Services
account that owns the requester VPC.
\item \code{requester-vpc-info.vpc-id} - The ID of the requester VPC.
\item \code{status-code} - The status of the VPC peering connection
(\code{pending-acceptance} | \code{failed} | \code{expired} | \code{provisioning} |
\code{active} | \code{deleting} | \code{deleted} | \code{rejected}).
\item \code{status-message} - A message that provides more information about
the status of the VPC peering connection, if applicable.
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{vpc-peering-connection-id} - The ID of the VPC peering connection.
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcPeeringConnectionIds}{The IDs of the VPC peering connections.

Default: Describes all your VPC peering connections.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}
}
\description{
Describes your VPC peering connections. The default is to describe all your VPC peering connections. Alternatively, you can specify specific VPC peering connection IDs or filter the results to include only the VPC peering connections that match specific criteria.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_vpc_peering_connections/} for full documentation.
}
\keyword{internal}
