% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_update_template_sync_config}
\alias{proton_update_template_sync_config}
\title{Update template sync configuration parameters, except for the
templateName and templateType}
\usage{
proton_update_template_sync_config(
  branch,
  repositoryName,
  repositoryProvider,
  subdirectory = NULL,
  templateName,
  templateType
)
}
\arguments{
\item{branch}{[required] The repository branch for your template.}

\item{repositoryName}{[required] The repository name (for example, \code{myrepos/myrepo}).}

\item{repositoryProvider}{[required] The repository provider.}

\item{subdirectory}{A subdirectory path to your template bundle version. When included,
limits the template bundle search to this repository directory.}

\item{templateName}{[required] The synced template name.}

\item{templateType}{[required] The synced template type.}
}
\description{
Update template sync configuration parameters, except for the \code{templateName} and \code{templateType}. Repository details (branch, name, and provider) should be of a linked repository. A linked repository is a repository that has been registered with Proton. For more information, see \code{\link[=proton_create_repository]{create_repository}}.

See \url{https://www.paws-r-sdk.com/docs/proton_update_template_sync_config/} for full documentation.
}
\keyword{internal}
