% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_describe_events}
\alias{elasticbeanstalk_describe_events}
\title{Returns list of event descriptions matching criteria up to the last 6
weeks}
\usage{
elasticbeanstalk_describe_events(
  ApplicationName = NULL,
  VersionLabel = NULL,
  TemplateName = NULL,
  EnvironmentId = NULL,
  EnvironmentName = NULL,
  PlatformArn = NULL,
  RequestId = NULL,
  Severity = NULL,
  StartTime = NULL,
  EndTime = NULL,
  MaxRecords = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ApplicationName}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to include only those associated with this application.}

\item{VersionLabel}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to those associated with this application version.}

\item{TemplateName}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to those that are associated with this environment configuration.}

\item{EnvironmentId}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to those associated with this environment.}

\item{EnvironmentName}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to those associated with this environment.}

\item{PlatformArn}{The ARN of a custom platform version. If specified, AWS Elastic
Beanstalk restricts the returned descriptions to those associated with
this custom platform version.}

\item{RequestId}{If specified, AWS Elastic Beanstalk restricts the described events to
include only those associated with this request ID.}

\item{Severity}{If specified, limits the events returned from this call to include only
those with the specified severity or higher.}

\item{StartTime}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to those that occur on or after this time.}

\item{EndTime}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to those that occur up to, but not including, the \code{EndTime}.}

\item{MaxRecords}{Specifies the maximum number of events that can be returned, beginning
with the most recent event.}

\item{NextToken}{Pagination token. If specified, the events return the next batch of
results.}
}
\description{
Returns list of event descriptions matching criteria up to the last 6 weeks.

See \url{https://www.paws-r-sdk.com/docs/elasticbeanstalk_describe_events/} for full documentation.
}
\keyword{internal}
