% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_fpga_image_attribute}
\alias{ec2_modify_fpga_image_attribute}
\title{Modifies the specified attribute of the specified Amazon FPGA Image
(AFI)}
\usage{
ec2_modify_fpga_image_attribute(
  DryRun = NULL,
  FpgaImageId,
  Attribute = NULL,
  OperationType = NULL,
  UserIds = NULL,
  UserGroups = NULL,
  ProductCodes = NULL,
  LoadPermission = NULL,
  Description = NULL,
  Name = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{FpgaImageId}{[required] The ID of the AFI.}

\item{Attribute}{The name of the attribute.}

\item{OperationType}{The operation type.}

\item{UserIds}{The Amazon Web Services account IDs. This parameter is valid only when
modifying the \code{loadPermission} attribute.}

\item{UserGroups}{The user groups. This parameter is valid only when modifying the
\code{loadPermission} attribute.}

\item{ProductCodes}{The product codes. After you add a product code to an AFI, it can't be
removed. This parameter is valid only when modifying the \code{productCodes}
attribute.}

\item{LoadPermission}{The load permission for the AFI.}

\item{Description}{A description for the AFI.}

\item{Name}{A name for the AFI.}
}
\description{
Modifies the specified attribute of the specified Amazon FPGA Image (AFI).

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_fpga_image_attribute/} for full documentation.
}
\keyword{internal}
