% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_traffic_mirror_targets}
\alias{ec2_describe_traffic_mirror_targets}
\title{Information about one or more Traffic Mirror targets}
\usage{
ec2_describe_traffic_mirror_targets(
  TrafficMirrorTargetIds = NULL,
  DryRun = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{TrafficMirrorTargetIds}{The ID of the Traffic Mirror targets.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{One or more filters. The possible values are:
\itemize{
\item \code{description}: The Traffic Mirror target description.
\item \code{network-interface-id}: The ID of the Traffic Mirror session network
interface.
\item \code{network-load-balancer-arn}: The Amazon Resource Name (ARN) of the
Network Load Balancer that is associated with the session.
\item \code{owner-id}: The ID of the account that owns the Traffic Mirror
session.
\item \code{traffic-mirror-target-id}: The ID of the Traffic Mirror target.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Information about one or more Traffic Mirror targets.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_traffic_mirror_targets/} for full documentation.
}
\keyword{internal}
