% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_bundle_tasks}
\alias{ec2_describe_bundle_tasks}
\title{Describes the specified bundle tasks or all of your bundle tasks}
\usage{
ec2_describe_bundle_tasks(BundleIds = NULL, Filters = NULL, DryRun = NULL)
}
\arguments{
\item{BundleIds}{The bundle task IDs.

Default: Describes all your bundle tasks.}

\item{Filters}{The filters.
\itemize{
\item \code{bundle-id} - The ID of the bundle task.
\item \code{error-code} - If the task failed, the error code returned.
\item \code{error-message} - If the task failed, the error message returned.
\item \code{instance-id} - The ID of the instance.
\item \code{progress} - The level of task completion, as a percentage (for
example, 20\%).
\item \code{s3-bucket} - The Amazon S3 bucket to store the AMI.
\item \code{s3-prefix} - The beginning of the AMI name.
\item \code{start-time} - The time the task started (for example,
2013-09-15T17:15:20.000Z).
\item \code{state} - The state of the task (\code{pending} | \verb{waiting-for-shutdown}
| \code{bundling} | \code{storing} | \code{cancelling} | \code{complete} | \code{failed}).
\item \code{update-time} - The time of the most recent update for the task.
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes the specified bundle tasks or all of your bundle tasks.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_bundle_tasks/} for full documentation.
}
\keyword{internal}
