% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_launch_template_versions}
\alias{ec2_delete_launch_template_versions}
\title{Deletes one or more versions of a launch template}
\usage{
ec2_delete_launch_template_versions(
  DryRun = NULL,
  LaunchTemplateId = NULL,
  LaunchTemplateName = NULL,
  Versions
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{LaunchTemplateId}{The ID of the launch template.

You must specify either the \code{LaunchTemplateId} or the
\code{LaunchTemplateName}, but not both.}

\item{LaunchTemplateName}{The name of the launch template.

You must specify either the \code{LaunchTemplateName} or the
\code{LaunchTemplateId}, but not both.}

\item{Versions}{[required] The version numbers of one or more launch template versions to delete.
You can specify up to 200 launch template version numbers.}
}
\description{
Deletes one or more versions of a launch template.

See \url{https://www.paws-r-sdk.com/docs/ec2_delete_launch_template_versions/} for full documentation.
}
\keyword{internal}
