% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_attach_volume}
\alias{ec2_attach_volume}
\title{Attaches an EBS volume to a running or stopped instance and exposes it
to the instance with the specified device name}
\usage{
ec2_attach_volume(Device, InstanceId, VolumeId, DryRun = NULL)
}
\arguments{
\item{Device}{[required] The device name (for example, \verb{/dev/sdh} or \code{xvdh}).}

\item{InstanceId}{[required] The ID of the instance.}

\item{VolumeId}{[required] The ID of the EBS volume. The volume and instance must be within the
same Availability Zone.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Attaches an EBS volume to a running or stopped instance and exposes it to the instance with the specified device name.

See \url{https://www.paws-r-sdk.com/docs/ec2_attach_volume/} for full documentation.
}
\keyword{internal}
