% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_delete_relational_database}
\alias{lightsail_delete_relational_database}
\title{Deletes a database in Amazon Lightsail}
\usage{
lightsail_delete_relational_database(relationalDatabaseName,
  skipFinalSnapshot, finalRelationalDatabaseSnapshotName)
}
\arguments{
\item{relationalDatabaseName}{[required] The name of the database that you are deleting.}

\item{skipFinalSnapshot}{Determines whether a final database snapshot is created before your
database is deleted. If \code{true} is specified, no database snapshot is
created. If \code{false} is specified, a database snapshot is created before
your database is deleted.

You must specify the \verb{final relational database snapshot name} parameter
if the \verb{skip final snapshot} parameter is \code{false}.

Default: \code{false}}

\item{finalRelationalDatabaseSnapshotName}{The name of the database snapshot created if \verb{skip final snapshot} is
\code{false}, which is the default value for that parameter.

Specifying this parameter and also specifying the \verb{skip final snapshot}
parameter to \code{true} results in an error.

Constraints:
\itemize{
\item Must contain from 2 to 255 alphanumeric characters, or hyphens.
\item The first and last character must be a letter or number.
}}
}
\description{
Deletes a database in Amazon Lightsail.
}
\details{
The \verb{delete relational database} operation supports tag-based access
control via resource tags applied to the resource identified by
relationalDatabaseName. For more information, see the \href{https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags}{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_relational_database(
  relationalDatabaseName = "string",
  skipFinalSnapshot = TRUE|FALSE,
  finalRelationalDatabaseSnapshotName = "string"
)
}
}

\keyword{internal}
