% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_disable_vpc_classic_link_dns_support}
\alias{ec2_disable_vpc_classic_link_dns_support}
\title{Disables ClassicLink DNS support for a VPC}
\usage{
ec2_disable_vpc_classic_link_dns_support(VpcId)
}
\arguments{
\item{VpcId}{The ID of the VPC.}
}
\description{
Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames
resolve to public IP addresses when addressed between a linked
EC2-Classic instance and instances in the VPC to which it\'s linked. For
more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html}{ClassicLink}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$disable_vpc_classic_link_dns_support(
  VpcId = "string"
)
}
}

\keyword{internal}
