% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourceexplorer_operations.R
\name{resourceexplorer_search}
\alias{resourceexplorer_search}
\title{Searches for resources and displays details about all resources that
match the specified criteria}
\usage{
resourceexplorer_search(
  MaxResults = NULL,
  NextToken = NULL,
  QueryString,
  ViewArn = NULL
)
}
\arguments{
\item{MaxResults}{The maximum number of results that you want included on each page of the
response. If you do not include this parameter, it defaults to a value
appropriate to the operation. If additional items exist beyond those
included in the current response, the \code{NextToken} response element is
present and has a value (is not null). Include that value as the
\code{NextToken} request parameter in the next call to the operation to get
the next part of the results.

An API operation can return fewer results than the maximum even when
there are more results available. You should check \code{NextToken} after
every operation to ensure that you receive all of the results.}

\item{NextToken}{The parameter for receiving additional results if you receive a
\code{NextToken} response in a previous request. A \code{NextToken} response
indicates that more output is available. Set this parameter to the value
of the previous call's \code{NextToken} response to indicate where the output
should continue from. The pagination tokens expire after 24 hours.}

\item{QueryString}{[required] A string that includes keywords and filters that specify the resources
that you want to include in the results.

For the complete syntax supported by the \code{QueryString} parameter, see
\href{https://docs.aws.amazon.com/resource-explorer/latest/userguide/using-search-query-syntax.html}{Search query syntax reference for Resource Explorer}.

The search is completely case insensitive. You can specify an empty
string to return all results up to the limit of 1,000 total results.

The operation can return only the first 1,000 results. If the resource
you want is not included, then use a different value for \code{QueryString}
to refine the results.}

\item{ViewArn}{Specifies the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon resource name (ARN)}
of the view to use for the query. If you don't specify a value for this
parameter, then the operation automatically uses the default view for
the Amazon Web Services Region in which you called this operation. If
the Region either doesn't have a default view or if you don't have
permission to use the default view, then the operation fails with a
\verb{401 Unauthorized} exception.}
}
\description{
Searches for resources and displays details about all resources that match the specified criteria. You must specify a query string.

See \url{https://www.paws-r-sdk.com/docs/resourceexplorer_search/} for full documentation.
}
\keyword{internal}
