# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include eventbridge_service.R
NULL

#' Activates a partner event source that has been deactivated
#'
#' @description
#' Activates a partner event source that has been deactivated. Once activated, your matching event bus will start receiving events from the event source.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_activate_event_source/](https://www.paws-r-sdk.com/docs/eventbridge_activate_event_source/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the partner event source to activate.
#'
#' @keywords internal
#'
#' @rdname eventbridge_activate_event_source
eventbridge_activate_event_source <- function(Name) {
  op <- new_operation(
    name = "ActivateEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$activate_event_source_input(Name = Name)
  output <- .eventbridge$activate_event_source_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$activate_event_source <- eventbridge_activate_event_source

#' Cancels the specified replay
#'
#' @description
#' Cancels the specified replay.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_cancel_replay/](https://www.paws-r-sdk.com/docs/eventbridge_cancel_replay/) for full documentation.
#'
#' @param ReplayName &#91;required&#93; The name of the replay to cancel.
#'
#' @keywords internal
#'
#' @rdname eventbridge_cancel_replay
eventbridge_cancel_replay <- function(ReplayName) {
  op <- new_operation(
    name = "CancelReplay",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$cancel_replay_input(ReplayName = ReplayName)
  output <- .eventbridge$cancel_replay_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$cancel_replay <- eventbridge_cancel_replay

#' Creates an API destination, which is an HTTP invocation endpoint
#' configured as a target for events
#'
#' @description
#' Creates an API destination, which is an HTTP invocation endpoint configured as a target for events.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_create_api_destination/](https://www.paws-r-sdk.com/docs/eventbridge_create_api_destination/) for full documentation.
#'
#' @param Name &#91;required&#93; The name for the API destination to create.
#' @param Description A description for the API destination to create.
#' @param ConnectionArn &#91;required&#93; The ARN of the connection to use for the API destination. The
#' destination endpoint must support the authorization type specified for
#' the connection.
#' @param InvocationEndpoint &#91;required&#93; The URL to the HTTP invocation endpoint for the API destination.
#' @param HttpMethod &#91;required&#93; The method to use for the request to the HTTP invocation endpoint.
#' @param InvocationRateLimitPerSecond The maximum number of requests per second to send to the HTTP invocation
#' endpoint.
#'
#' @keywords internal
#'
#' @rdname eventbridge_create_api_destination
eventbridge_create_api_destination <- function(Name, Description = NULL, ConnectionArn, InvocationEndpoint, HttpMethod, InvocationRateLimitPerSecond = NULL) {
  op <- new_operation(
    name = "CreateApiDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$create_api_destination_input(Name = Name, Description = Description, ConnectionArn = ConnectionArn, InvocationEndpoint = InvocationEndpoint, HttpMethod = HttpMethod, InvocationRateLimitPerSecond = InvocationRateLimitPerSecond)
  output <- .eventbridge$create_api_destination_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$create_api_destination <- eventbridge_create_api_destination

#' Creates an archive of events with the specified settings
#'
#' @description
#' Creates an archive of events with the specified settings. When you create an archive, incoming events might not immediately start being sent to the archive. Allow a short period of time for changes to take effect. If you do not specify a pattern to filter events sent to the archive, all events are sent to the archive except replayed events. Replayed events are not sent to an archive.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_create_archive/](https://www.paws-r-sdk.com/docs/eventbridge_create_archive/) for full documentation.
#'
#' @param ArchiveName &#91;required&#93; The name for the archive to create.
#' @param EventSourceArn &#91;required&#93; The ARN of the event bus that sends events to the archive.
#' @param Description A description for the archive.
#' @param EventPattern An event pattern to use to filter events sent to the archive.
#' @param RetentionDays The number of days to retain events for. Default value is 0. If set to
#' 0, events are retained indefinitely
#'
#' @keywords internal
#'
#' @rdname eventbridge_create_archive
eventbridge_create_archive <- function(ArchiveName, EventSourceArn, Description = NULL, EventPattern = NULL, RetentionDays = NULL) {
  op <- new_operation(
    name = "CreateArchive",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$create_archive_input(ArchiveName = ArchiveName, EventSourceArn = EventSourceArn, Description = Description, EventPattern = EventPattern, RetentionDays = RetentionDays)
  output <- .eventbridge$create_archive_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$create_archive <- eventbridge_create_archive

#' Creates a connection
#'
#' @description
#' Creates a connection. A connection defines the authorization type and credentials to use for authorization with an API destination HTTP endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_create_connection/](https://www.paws-r-sdk.com/docs/eventbridge_create_connection/) for full documentation.
#'
#' @param Name &#91;required&#93; The name for the connection to create.
#' @param Description A description for the connection to create.
#' @param AuthorizationType &#91;required&#93; The type of authorization to use for the connection.
#' 
#' OAUTH tokens are refreshed when a 401 or 407 response is returned.
#' @param AuthParameters &#91;required&#93; A `CreateConnectionAuthRequestParameters` object that contains the
#' authorization parameters to use to authorize with the endpoint.
#'
#' @keywords internal
#'
#' @rdname eventbridge_create_connection
eventbridge_create_connection <- function(Name, Description = NULL, AuthorizationType, AuthParameters) {
  op <- new_operation(
    name = "CreateConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$create_connection_input(Name = Name, Description = Description, AuthorizationType = AuthorizationType, AuthParameters = AuthParameters)
  output <- .eventbridge$create_connection_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$create_connection <- eventbridge_create_connection

#' Creates a global endpoint
#'
#' @description
#' Creates a global endpoint. Global endpoints improve your application's availability by making it regional-fault tolerant. To do this, you define a primary and secondary Region with event buses in each Region. You also create a Amazon Route 53 health check that will tell EventBridge to route events to the secondary Region when an "unhealthy" state is encountered and events will be routed back to the primary Region when the health check reports a "healthy" state.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_create_endpoint/](https://www.paws-r-sdk.com/docs/eventbridge_create_endpoint/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the global endpoint. For example,
#' `"Name":"us-east-2-custom_bus_A-endpoint"`.
#' @param Description A description of the global endpoint.
#' @param RoutingConfig &#91;required&#93; Configure the routing policy, including the health check and secondary
#' Region..
#' @param ReplicationConfig Enable or disable event replication. The default state is `ENABLED`
#' which means you must supply a `RoleArn`. If you don't have a `RoleArn`
#' or you don't want event replication enabled, set the state to
#' `DISABLED`.
#' @param EventBuses &#91;required&#93; Define the event buses used.
#' 
#' The names of the event buses must be identical in each Region.
#' @param RoleArn The ARN of the role used for replication.
#'
#' @keywords internal
#'
#' @rdname eventbridge_create_endpoint
eventbridge_create_endpoint <- function(Name, Description = NULL, RoutingConfig, ReplicationConfig = NULL, EventBuses, RoleArn = NULL) {
  op <- new_operation(
    name = "CreateEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$create_endpoint_input(Name = Name, Description = Description, RoutingConfig = RoutingConfig, ReplicationConfig = ReplicationConfig, EventBuses = EventBuses, RoleArn = RoleArn)
  output <- .eventbridge$create_endpoint_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$create_endpoint <- eventbridge_create_endpoint

#' Creates a new event bus within your account
#'
#' @description
#' Creates a new event bus within your account. This can be a custom event bus which you can use to receive events from your custom applications and services, or it can be a partner event bus which can be matched to a partner event source.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_create_event_bus/](https://www.paws-r-sdk.com/docs/eventbridge_create_event_bus/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the new event bus.
#' 
#' Custom event bus names can't contain the `/` character, but you can use
#' the `/` character in partner event bus names. In addition, for partner
#' event buses, the name must exactly match the name of the partner event
#' source that this event bus is matched to.
#' 
#' You can't use the name `default` for a custom event bus, as this name is
#' already used for your account's default event bus.
#' @param EventSourceName If you are creating a partner event bus, this specifies the partner
#' event source that the new event bus will be matched with.
#' @param Tags Tags to associate with the event bus.
#'
#' @keywords internal
#'
#' @rdname eventbridge_create_event_bus
eventbridge_create_event_bus <- function(Name, EventSourceName = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateEventBus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$create_event_bus_input(Name = Name, EventSourceName = EventSourceName, Tags = Tags)
  output <- .eventbridge$create_event_bus_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$create_event_bus <- eventbridge_create_event_bus

#' Called by an SaaS partner to create a partner event source
#'
#' @description
#' Called by an SaaS partner to create a partner event source. This operation is not used by Amazon Web Services customers.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_create_partner_event_source/](https://www.paws-r-sdk.com/docs/eventbridge_create_partner_event_source/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the partner event source. This name must be unique and must
#' be in the format ` partner_name/event_namespace/event_name `. The Amazon
#' Web Services account that wants to use this partner event source must
#' create a partner event bus with a name that matches the name of the
#' partner event source.
#' @param Account &#91;required&#93; The Amazon Web Services account ID that is permitted to create a
#' matching partner event bus for this partner event source.
#'
#' @keywords internal
#'
#' @rdname eventbridge_create_partner_event_source
eventbridge_create_partner_event_source <- function(Name, Account) {
  op <- new_operation(
    name = "CreatePartnerEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$create_partner_event_source_input(Name = Name, Account = Account)
  output <- .eventbridge$create_partner_event_source_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$create_partner_event_source <- eventbridge_create_partner_event_source

#' You can use this operation to temporarily stop receiving events from the
#' specified partner event source
#'
#' @description
#' You can use this operation to temporarily stop receiving events from the specified partner event source. The matching event bus is not deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_deactivate_event_source/](https://www.paws-r-sdk.com/docs/eventbridge_deactivate_event_source/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the partner event source to deactivate.
#'
#' @keywords internal
#'
#' @rdname eventbridge_deactivate_event_source
eventbridge_deactivate_event_source <- function(Name) {
  op <- new_operation(
    name = "DeactivateEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$deactivate_event_source_input(Name = Name)
  output <- .eventbridge$deactivate_event_source_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$deactivate_event_source <- eventbridge_deactivate_event_source

#' Removes all authorization parameters from the connection
#'
#' @description
#' Removes all authorization parameters from the connection. This lets you remove the secret from the connection so you can reuse it without having to create a new connection.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_deauthorize_connection/](https://www.paws-r-sdk.com/docs/eventbridge_deauthorize_connection/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the connection to remove authorization from.
#'
#' @keywords internal
#'
#' @rdname eventbridge_deauthorize_connection
eventbridge_deauthorize_connection <- function(Name) {
  op <- new_operation(
    name = "DeauthorizeConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$deauthorize_connection_input(Name = Name)
  output <- .eventbridge$deauthorize_connection_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$deauthorize_connection <- eventbridge_deauthorize_connection

#' Deletes the specified API destination
#'
#' @description
#' Deletes the specified API destination.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_delete_api_destination/](https://www.paws-r-sdk.com/docs/eventbridge_delete_api_destination/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the destination to delete.
#'
#' @keywords internal
#'
#' @rdname eventbridge_delete_api_destination
eventbridge_delete_api_destination <- function(Name) {
  op <- new_operation(
    name = "DeleteApiDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$delete_api_destination_input(Name = Name)
  output <- .eventbridge$delete_api_destination_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$delete_api_destination <- eventbridge_delete_api_destination

#' Deletes the specified archive
#'
#' @description
#' Deletes the specified archive.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_delete_archive/](https://www.paws-r-sdk.com/docs/eventbridge_delete_archive/) for full documentation.
#'
#' @param ArchiveName &#91;required&#93; The name of the archive to delete.
#'
#' @keywords internal
#'
#' @rdname eventbridge_delete_archive
eventbridge_delete_archive <- function(ArchiveName) {
  op <- new_operation(
    name = "DeleteArchive",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$delete_archive_input(ArchiveName = ArchiveName)
  output <- .eventbridge$delete_archive_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$delete_archive <- eventbridge_delete_archive

#' Deletes a connection
#'
#' @description
#' Deletes a connection.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_delete_connection/](https://www.paws-r-sdk.com/docs/eventbridge_delete_connection/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the connection to delete.
#'
#' @keywords internal
#'
#' @rdname eventbridge_delete_connection
eventbridge_delete_connection <- function(Name) {
  op <- new_operation(
    name = "DeleteConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$delete_connection_input(Name = Name)
  output <- .eventbridge$delete_connection_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$delete_connection <- eventbridge_delete_connection

#' Delete an existing global endpoint
#'
#' @description
#' Delete an existing global endpoint. For more information about global endpoints, see [Making applications Regional-fault tolerant with global endpoints and event replication](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html) in the *Amazon EventBridge User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_delete_endpoint/](https://www.paws-r-sdk.com/docs/eventbridge_delete_endpoint/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the endpoint you want to delete. For example,
#' `"Name":"us-east-2-custom_bus_A-endpoint"`..
#'
#' @keywords internal
#'
#' @rdname eventbridge_delete_endpoint
eventbridge_delete_endpoint <- function(Name) {
  op <- new_operation(
    name = "DeleteEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$delete_endpoint_input(Name = Name)
  output <- .eventbridge$delete_endpoint_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$delete_endpoint <- eventbridge_delete_endpoint

#' Deletes the specified custom event bus or partner event bus
#'
#' @description
#' Deletes the specified custom event bus or partner event bus. All rules associated with this event bus need to be deleted. You can't delete your account's default event bus.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_delete_event_bus/](https://www.paws-r-sdk.com/docs/eventbridge_delete_event_bus/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the event bus to delete.
#'
#' @keywords internal
#'
#' @rdname eventbridge_delete_event_bus
eventbridge_delete_event_bus <- function(Name) {
  op <- new_operation(
    name = "DeleteEventBus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$delete_event_bus_input(Name = Name)
  output <- .eventbridge$delete_event_bus_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$delete_event_bus <- eventbridge_delete_event_bus

#' This operation is used by SaaS partners to delete a partner event source
#'
#' @description
#' This operation is used by SaaS partners to delete a partner event source. This operation is not used by Amazon Web Services customers.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_delete_partner_event_source/](https://www.paws-r-sdk.com/docs/eventbridge_delete_partner_event_source/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the event source to delete.
#' @param Account &#91;required&#93; The Amazon Web Services account ID of the Amazon Web Services customer
#' that the event source was created for.
#'
#' @keywords internal
#'
#' @rdname eventbridge_delete_partner_event_source
eventbridge_delete_partner_event_source <- function(Name, Account) {
  op <- new_operation(
    name = "DeletePartnerEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$delete_partner_event_source_input(Name = Name, Account = Account)
  output <- .eventbridge$delete_partner_event_source_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$delete_partner_event_source <- eventbridge_delete_partner_event_source

#' Deletes the specified rule
#'
#' @description
#' Deletes the specified rule.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_delete_rule/](https://www.paws-r-sdk.com/docs/eventbridge_delete_rule/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#' @param Force If this is a managed rule, created by an Amazon Web Services service on
#' your behalf, you must specify `Force` as `True` to delete the rule. This
#' parameter is ignored for rules that are not managed rules. You can check
#' whether a rule is a managed rule by using
#' [`describe_rule`][eventbridge_describe_rule] or
#' [`list_rules`][eventbridge_list_rules] and checking the `ManagedBy`
#' field of the response.
#'
#' @keywords internal
#'
#' @rdname eventbridge_delete_rule
eventbridge_delete_rule <- function(Name, EventBusName = NULL, Force = NULL) {
  op <- new_operation(
    name = "DeleteRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$delete_rule_input(Name = Name, EventBusName = EventBusName, Force = Force)
  output <- .eventbridge$delete_rule_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$delete_rule <- eventbridge_delete_rule

#' Retrieves details about an API destination
#'
#' @description
#' Retrieves details about an API destination.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_describe_api_destination/](https://www.paws-r-sdk.com/docs/eventbridge_describe_api_destination/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the API destination to retrieve.
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_api_destination
eventbridge_describe_api_destination <- function(Name) {
  op <- new_operation(
    name = "DescribeApiDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_api_destination_input(Name = Name)
  output <- .eventbridge$describe_api_destination_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_api_destination <- eventbridge_describe_api_destination

#' Retrieves details about an archive
#'
#' @description
#' Retrieves details about an archive.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_describe_archive/](https://www.paws-r-sdk.com/docs/eventbridge_describe_archive/) for full documentation.
#'
#' @param ArchiveName &#91;required&#93; The name of the archive to retrieve.
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_archive
eventbridge_describe_archive <- function(ArchiveName) {
  op <- new_operation(
    name = "DescribeArchive",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_archive_input(ArchiveName = ArchiveName)
  output <- .eventbridge$describe_archive_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_archive <- eventbridge_describe_archive

#' Retrieves details about a connection
#'
#' @description
#' Retrieves details about a connection.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_describe_connection/](https://www.paws-r-sdk.com/docs/eventbridge_describe_connection/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the connection to retrieve.
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_connection
eventbridge_describe_connection <- function(Name) {
  op <- new_operation(
    name = "DescribeConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_connection_input(Name = Name)
  output <- .eventbridge$describe_connection_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_connection <- eventbridge_describe_connection

#' Get the information about an existing global endpoint
#'
#' @description
#' Get the information about an existing global endpoint. For more information about global endpoints, see [Making applications Regional-fault tolerant with global endpoints and event replication](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html) in the *Amazon EventBridge User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_describe_endpoint/](https://www.paws-r-sdk.com/docs/eventbridge_describe_endpoint/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the endpoint you want to get information about. For example,
#' `"Name":"us-east-2-custom_bus_A-endpoint"`.
#' @param HomeRegion The primary Region of the endpoint you want to get information about.
#' For example `"HomeRegion": "us-east-1"`.
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_endpoint
eventbridge_describe_endpoint <- function(Name, HomeRegion = NULL) {
  op <- new_operation(
    name = "DescribeEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_endpoint_input(Name = Name, HomeRegion = HomeRegion)
  output <- .eventbridge$describe_endpoint_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_endpoint <- eventbridge_describe_endpoint

#' Displays details about an event bus in your account
#'
#' @description
#' Displays details about an event bus in your account. This can include the external Amazon Web Services accounts that are permitted to write events to your default event bus, and the associated policy. For custom event buses and partner event buses, it displays the name, ARN, policy, state, and creation time.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_describe_event_bus/](https://www.paws-r-sdk.com/docs/eventbridge_describe_event_bus/) for full documentation.
#'
#' @param Name The name or ARN of the event bus to show details for. If you omit this,
#' the default event bus is displayed.
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_event_bus
eventbridge_describe_event_bus <- function(Name = NULL) {
  op <- new_operation(
    name = "DescribeEventBus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_event_bus_input(Name = Name)
  output <- .eventbridge$describe_event_bus_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_event_bus <- eventbridge_describe_event_bus

#' This operation lists details about a partner event source that is shared
#' with your account
#'
#' @description
#' This operation lists details about a partner event source that is shared with your account.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_describe_event_source/](https://www.paws-r-sdk.com/docs/eventbridge_describe_event_source/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the partner event source to display the details of.
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_event_source
eventbridge_describe_event_source <- function(Name) {
  op <- new_operation(
    name = "DescribeEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_event_source_input(Name = Name)
  output <- .eventbridge$describe_event_source_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_event_source <- eventbridge_describe_event_source

#' An SaaS partner can use this operation to list details about a partner
#' event source that they have created
#'
#' @description
#' An SaaS partner can use this operation to list details about a partner event source that they have created. Amazon Web Services customers do not use this operation. Instead, Amazon Web Services customers can use [`describe_event_source`][eventbridge_describe_event_source] to see details about a partner event source that is shared with them.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_describe_partner_event_source/](https://www.paws-r-sdk.com/docs/eventbridge_describe_partner_event_source/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the event source to display.
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_partner_event_source
eventbridge_describe_partner_event_source <- function(Name) {
  op <- new_operation(
    name = "DescribePartnerEventSource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_partner_event_source_input(Name = Name)
  output <- .eventbridge$describe_partner_event_source_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_partner_event_source <- eventbridge_describe_partner_event_source

#' Retrieves details about a replay
#'
#' @description
#' Retrieves details about a replay. Use [`describe_replay`][eventbridge_describe_replay] to determine the progress of a running replay. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you use [`start_replay`][eventbridge_start_replay] and specify an `EventStartTime` and an `EventEndTime` that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use [`describe_replay`][eventbridge_describe_replay] to determine the progress of a replay. The value returned for `EventLastReplayedTime` indicates the time within the specified time range associated with the last event replayed.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_describe_replay/](https://www.paws-r-sdk.com/docs/eventbridge_describe_replay/) for full documentation.
#'
#' @param ReplayName &#91;required&#93; The name of the replay to retrieve.
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_replay
eventbridge_describe_replay <- function(ReplayName) {
  op <- new_operation(
    name = "DescribeReplay",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_replay_input(ReplayName = ReplayName)
  output <- .eventbridge$describe_replay_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_replay <- eventbridge_describe_replay

#' Describes the specified rule
#'
#' @description
#' Describes the specified rule.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_describe_rule/](https://www.paws-r-sdk.com/docs/eventbridge_describe_rule/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#'
#' @keywords internal
#'
#' @rdname eventbridge_describe_rule
eventbridge_describe_rule <- function(Name, EventBusName = NULL) {
  op <- new_operation(
    name = "DescribeRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$describe_rule_input(Name = Name, EventBusName = EventBusName)
  output <- .eventbridge$describe_rule_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$describe_rule <- eventbridge_describe_rule

#' Disables the specified rule
#'
#' @description
#' Disables the specified rule. A disabled rule won't match any events, and won't self-trigger if it has a schedule expression.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_disable_rule/](https://www.paws-r-sdk.com/docs/eventbridge_disable_rule/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#'
#' @keywords internal
#'
#' @rdname eventbridge_disable_rule
eventbridge_disable_rule <- function(Name, EventBusName = NULL) {
  op <- new_operation(
    name = "DisableRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$disable_rule_input(Name = Name, EventBusName = EventBusName)
  output <- .eventbridge$disable_rule_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$disable_rule <- eventbridge_disable_rule

#' Enables the specified rule
#'
#' @description
#' Enables the specified rule. If the rule does not exist, the operation fails.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_enable_rule/](https://www.paws-r-sdk.com/docs/eventbridge_enable_rule/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#'
#' @keywords internal
#'
#' @rdname eventbridge_enable_rule
eventbridge_enable_rule <- function(Name, EventBusName = NULL) {
  op <- new_operation(
    name = "EnableRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$enable_rule_input(Name = Name, EventBusName = EventBusName)
  output <- .eventbridge$enable_rule_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$enable_rule <- eventbridge_enable_rule

#' Retrieves a list of API destination in the account in the current Region
#'
#' @description
#' Retrieves a list of API destination in the account in the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_list_api_destinations/](https://www.paws-r-sdk.com/docs/eventbridge_list_api_destinations/) for full documentation.
#'
#' @param NamePrefix A name prefix to filter results returned. Only API destinations with a
#' name that starts with the prefix are returned.
#' @param ConnectionArn The ARN of the connection specified for the API destination.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of API destinations to include in the response.
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_api_destinations
eventbridge_list_api_destinations <- function(NamePrefix = NULL, ConnectionArn = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListApiDestinations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_api_destinations_input(NamePrefix = NamePrefix, ConnectionArn = ConnectionArn, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_api_destinations_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_api_destinations <- eventbridge_list_api_destinations

#' Lists your archives
#'
#' @description
#' Lists your archives. You can either list all the archives or you can provide a prefix to match to the archive names. Filter parameters are exclusive.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_list_archives/](https://www.paws-r-sdk.com/docs/eventbridge_list_archives/) for full documentation.
#'
#' @param NamePrefix A name prefix to filter the archives returned. Only archives with name
#' that match the prefix are returned.
#' @param EventSourceArn The ARN of the event source associated with the archive.
#' @param State The state of the archive.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_archives
eventbridge_list_archives <- function(NamePrefix = NULL, EventSourceArn = NULL, State = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListArchives",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_archives_input(NamePrefix = NamePrefix, EventSourceArn = EventSourceArn, State = State, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_archives_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_archives <- eventbridge_list_archives

#' Retrieves a list of connections from the account
#'
#' @description
#' Retrieves a list of connections from the account.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_list_connections/](https://www.paws-r-sdk.com/docs/eventbridge_list_connections/) for full documentation.
#'
#' @param NamePrefix A name prefix to filter results returned. Only connections with a name
#' that starts with the prefix are returned.
#' @param ConnectionState The state of the connection.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of connections to return.
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_connections
eventbridge_list_connections <- function(NamePrefix = NULL, ConnectionState = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_connections_input(NamePrefix = NamePrefix, ConnectionState = ConnectionState, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_connections_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_connections <- eventbridge_list_connections

#' List the global endpoints associated with this account
#'
#' @description
#' List the global endpoints associated with this account. For more information about global endpoints, see [Making applications Regional-fault tolerant with global endpoints and event replication](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html) in the *Amazon EventBridge User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_list_endpoints/](https://www.paws-r-sdk.com/docs/eventbridge_list_endpoints/) for full documentation.
#'
#' @param NamePrefix A value that will return a subset of the endpoints associated with this
#' account. For example, `"NamePrefix": "ABC"` will return all endpoints
#' with "ABC" in the name.
#' @param HomeRegion The primary Region of the endpoints associated with this account. For
#' example `"HomeRegion": "us-east-1"`.
#' @param NextToken If `nextToken` is returned, there are more results available. The value
#' of `nextToken` is a unique pagination token for each page. Make the call
#' again using the returned token to retrieve the next page. Keep all other
#' arguments unchanged. Each pagination token expires after 24 hours. Using
#' an expired pagination token will return an HTTP 400 InvalidToken error.
#' @param MaxResults The maximum number of results returned by the call.
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_endpoints
eventbridge_list_endpoints <- function(NamePrefix = NULL, HomeRegion = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_endpoints_input(NamePrefix = NamePrefix, HomeRegion = HomeRegion, NextToken = NextToken, MaxResults = MaxResults)
  output <- .eventbridge$list_endpoints_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_endpoints <- eventbridge_list_endpoints

#' Lists all the event buses in your account, including the default event
#' bus, custom event buses, and partner event buses
#'
#' @description
#' Lists all the event buses in your account, including the default event bus, custom event buses, and partner event buses.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_list_event_buses/](https://www.paws-r-sdk.com/docs/eventbridge_list_event_buses/) for full documentation.
#'
#' @param NamePrefix Specifying this limits the results to only those event buses with names
#' that start with the specified prefix.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit Specifying this limits the number of results returned by this operation.
#' The operation also returns a NextToken which you can use in a subsequent
#' operation to retrieve the next set of results.
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_event_buses
eventbridge_list_event_buses <- function(NamePrefix = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListEventBuses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_event_buses_input(NamePrefix = NamePrefix, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_event_buses_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_event_buses <- eventbridge_list_event_buses

#' You can use this to see all the partner event sources that have been
#' shared with your Amazon Web Services account
#'
#' @description
#' You can use this to see all the partner event sources that have been shared with your Amazon Web Services account. For more information about partner event sources, see [`create_event_bus`][eventbridge_create_event_bus].
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_list_event_sources/](https://www.paws-r-sdk.com/docs/eventbridge_list_event_sources/) for full documentation.
#'
#' @param NamePrefix Specifying this limits the results to only those partner event sources
#' with names that start with the specified prefix.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit Specifying this limits the number of results returned by this operation.
#' The operation also returns a NextToken which you can use in a subsequent
#' operation to retrieve the next set of results.
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_event_sources
eventbridge_list_event_sources <- function(NamePrefix = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListEventSources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_event_sources_input(NamePrefix = NamePrefix, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_event_sources_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_event_sources <- eventbridge_list_event_sources

#' An SaaS partner can use this operation to display the Amazon Web
#' Services account ID that a particular partner event source name is
#' associated with
#'
#' @description
#' An SaaS partner can use this operation to display the Amazon Web Services account ID that a particular partner event source name is associated with. This operation is not used by Amazon Web Services customers.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_list_partner_event_source_accounts/](https://www.paws-r-sdk.com/docs/eventbridge_list_partner_event_source_accounts/) for full documentation.
#'
#' @param EventSourceName &#91;required&#93; The name of the partner event source to display account information
#' about.
#' @param NextToken The token returned by a previous call to this operation. Specifying this
#' retrieves the next set of results.
#' @param Limit Specifying this limits the number of results returned by this operation.
#' The operation also returns a NextToken which you can use in a subsequent
#' operation to retrieve the next set of results.
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_partner_event_source_accounts
eventbridge_list_partner_event_source_accounts <- function(EventSourceName, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListPartnerEventSourceAccounts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_partner_event_source_accounts_input(EventSourceName = EventSourceName, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_partner_event_source_accounts_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_partner_event_source_accounts <- eventbridge_list_partner_event_source_accounts

#' An SaaS partner can use this operation to list all the partner event
#' source names that they have created
#'
#' @description
#' An SaaS partner can use this operation to list all the partner event source names that they have created. This operation is not used by Amazon Web Services customers.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_list_partner_event_sources/](https://www.paws-r-sdk.com/docs/eventbridge_list_partner_event_sources/) for full documentation.
#'
#' @param NamePrefix &#91;required&#93; If you specify this, the results are limited to only those partner event
#' sources that start with the string you specify.
#' @param NextToken The token returned by a previous call to this operation. Specifying this
#' retrieves the next set of results.
#' @param Limit pecifying this limits the number of results returned by this operation.
#' The operation also returns a NextToken which you can use in a subsequent
#' operation to retrieve the next set of results.
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_partner_event_sources
eventbridge_list_partner_event_sources <- function(NamePrefix, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListPartnerEventSources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_partner_event_sources_input(NamePrefix = NamePrefix, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_partner_event_sources_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_partner_event_sources <- eventbridge_list_partner_event_sources

#' Lists your replays
#'
#' @description
#' Lists your replays. You can either list all the replays or you can provide a prefix to match to the replay names. Filter parameters are exclusive.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_list_replays/](https://www.paws-r-sdk.com/docs/eventbridge_list_replays/) for full documentation.
#'
#' @param NamePrefix A name prefix to filter the replays returned. Only replays with name
#' that match the prefix are returned.
#' @param State The state of the replay.
#' @param EventSourceArn The ARN of the archive from which the events are replayed.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of replays to retrieve.
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_replays
eventbridge_list_replays <- function(NamePrefix = NULL, State = NULL, EventSourceArn = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListReplays",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_replays_input(NamePrefix = NamePrefix, State = State, EventSourceArn = EventSourceArn, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_replays_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_replays <- eventbridge_list_replays

#' Lists the rules for the specified target
#'
#' @description
#' Lists the rules for the specified target. You can see which of the rules in Amazon EventBridge can invoke a specific target in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_list_rule_names_by_target/](https://www.paws-r-sdk.com/docs/eventbridge_list_rule_names_by_target/) for full documentation.
#'
#' @param TargetArn &#91;required&#93; The Amazon Resource Name (ARN) of the target resource.
#' @param EventBusName The name or ARN of the event bus to list rules for. If you omit this,
#' the default event bus is used.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_rule_names_by_target
eventbridge_list_rule_names_by_target <- function(TargetArn, EventBusName = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRuleNamesByTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_rule_names_by_target_input(TargetArn = TargetArn, EventBusName = EventBusName, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_rule_names_by_target_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_rule_names_by_target <- eventbridge_list_rule_names_by_target

#' Lists your Amazon EventBridge rules
#'
#' @description
#' Lists your Amazon EventBridge rules. You can either list all the rules or you can provide a prefix to match to the rule names.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_list_rules/](https://www.paws-r-sdk.com/docs/eventbridge_list_rules/) for full documentation.
#'
#' @param NamePrefix The prefix matching the rule name.
#' @param EventBusName The name or ARN of the event bus to list the rules for. If you omit
#' this, the default event bus is used.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_rules
eventbridge_list_rules <- function(NamePrefix = NULL, EventBusName = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_rules_input(NamePrefix = NamePrefix, EventBusName = EventBusName, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_rules_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_rules <- eventbridge_list_rules

#' Displays the tags associated with an EventBridge resource
#'
#' @description
#' Displays the tags associated with an EventBridge resource. In EventBridge, rules and event buses can be tagged.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/eventbridge_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of the EventBridge resource for which you want to view tags.
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_tags_for_resource
eventbridge_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .eventbridge$list_tags_for_resource_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_tags_for_resource <- eventbridge_list_tags_for_resource

#' Lists the targets assigned to the specified rule
#'
#' @description
#' Lists the targets assigned to the specified rule.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_list_targets_by_rule/](https://www.paws-r-sdk.com/docs/eventbridge_list_targets_by_rule/) for full documentation.
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#' @param NextToken The token returned by a previous call to retrieve the next set of
#' results.
#' @param Limit The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname eventbridge_list_targets_by_rule
eventbridge_list_targets_by_rule <- function(Rule, EventBusName = NULL, NextToken = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListTargetsByRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$list_targets_by_rule_input(Rule = Rule, EventBusName = EventBusName, NextToken = NextToken, Limit = Limit)
  output <- .eventbridge$list_targets_by_rule_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$list_targets_by_rule <- eventbridge_list_targets_by_rule

#' Sends custom events to Amazon EventBridge so that they can be matched to
#' rules
#'
#' @description
#' Sends custom events to Amazon EventBridge so that they can be matched to rules.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_put_events/](https://www.paws-r-sdk.com/docs/eventbridge_put_events/) for full documentation.
#'
#' @param Entries &#91;required&#93; The entry that defines an event in your system. You can specify several
#' parameters for the entry such as the source and type of the event,
#' resources associated with the event, and so on.
#' @param EndpointId The URL subdomain of the endpoint. For example, if the URL for Endpoint
#' is https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId
#' is `abcde.veo`.
#' 
#' When using Java, you must include `auth-crt` on the class path.
#'
#' @keywords internal
#'
#' @rdname eventbridge_put_events
eventbridge_put_events <- function(Entries, EndpointId = NULL) {
  op <- new_operation(
    name = "PutEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$put_events_input(Entries = Entries, EndpointId = EndpointId)
  output <- .eventbridge$put_events_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$put_events <- eventbridge_put_events

#' This is used by SaaS partners to write events to a customer's partner
#' event bus
#'
#' @description
#' This is used by SaaS partners to write events to a customer's partner event bus. Amazon Web Services customers do not use this operation.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_put_partner_events/](https://www.paws-r-sdk.com/docs/eventbridge_put_partner_events/) for full documentation.
#'
#' @param Entries &#91;required&#93; The list of events to write to the event bus.
#'
#' @keywords internal
#'
#' @rdname eventbridge_put_partner_events
eventbridge_put_partner_events <- function(Entries) {
  op <- new_operation(
    name = "PutPartnerEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$put_partner_events_input(Entries = Entries)
  output <- .eventbridge$put_partner_events_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$put_partner_events <- eventbridge_put_partner_events

#' Running PutPermission permits the specified Amazon Web Services account
#' or Amazon Web Services organization to put events to the specified event
#' bus
#'
#' @description
#' Running [`put_permission`][eventbridge_put_permission] permits the specified Amazon Web Services account or Amazon Web Services organization to put events to the specified *event bus*. Amazon EventBridge (CloudWatch Events) rules in your account are triggered by these events arriving to an event bus in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_put_permission/](https://www.paws-r-sdk.com/docs/eventbridge_put_permission/) for full documentation.
#'
#' @param EventBusName The name of the event bus associated with the rule. If you omit this,
#' the default event bus is used.
#' @param Action The action that you are enabling the other account to perform.
#' @param Principal The 12-digit Amazon Web Services account ID that you are permitting to
#' put events to your default event bus. Specify "*" to permit any account
#' to put events to your default event bus.
#' 
#' If you specify "*" without specifying `Condition`, avoid creating rules
#' that may match undesirable events. To create more secure rules, make
#' sure that the event pattern for each rule contains an `account` field
#' with a specific account ID from which to receive events. Rules with an
#' account field do not match any events sent from other accounts.
#' @param StatementId An identifier string for the external account that you are granting
#' permissions to. If you later want to revoke the permission for this
#' external account, specify this `StatementId` when you run
#' [`remove_permission`][eventbridge_remove_permission].
#' 
#' Each `StatementId` must be unique.
#' @param Condition This parameter enables you to limit the permission to accounts that
#' fulfill a certain condition, such as being a member of a certain Amazon
#' Web Services organization. For more information about Amazon Web
#' Services Organizations, see [What Is Amazon Web Services
#' Organizations](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_introduction.html)
#' in the *Amazon Web Services Organizations User Guide*.
#' 
#' If you specify `Condition` with an Amazon Web Services organization ID,
#' and specify "*" as the value for `Principal`, you grant permission to
#' all the accounts in the named organization.
#' 
#' The `Condition` is a JSON string which must contain `Type`, `Key`, and
#' `Value` fields.
#' @param Policy A JSON string that describes the permission policy statement. You can
#' include a `Policy` parameter in the request instead of using the
#' `StatementId`, `Action`, `Principal`, or `Condition` parameters.
#'
#' @keywords internal
#'
#' @rdname eventbridge_put_permission
eventbridge_put_permission <- function(EventBusName = NULL, Action = NULL, Principal = NULL, StatementId = NULL, Condition = NULL, Policy = NULL) {
  op <- new_operation(
    name = "PutPermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$put_permission_input(EventBusName = EventBusName, Action = Action, Principal = Principal, StatementId = StatementId, Condition = Condition, Policy = Policy)
  output <- .eventbridge$put_permission_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$put_permission <- eventbridge_put_permission

#' Creates or updates the specified rule
#'
#' @description
#' Creates or updates the specified rule. Rules are enabled by default, or based on value of the state. You can disable a rule using [`disable_rule`][eventbridge_disable_rule].
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_put_rule/](https://www.paws-r-sdk.com/docs/eventbridge_put_rule/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the rule that you are creating or updating.
#' @param ScheduleExpression The scheduling expression. For example, "cron(0 20 * * ? *)" or
#' "rate(5 minutes)".
#' @param EventPattern The event pattern. For more information, see [Amazon EventBridge event
#' patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-event-patterns.html)
#' in the *Amazon EventBridge User Guide*.
#' @param State The state of the rule.
#' 
#' Valid values include:
#' 
#' -   `DISABLED`: The rule is disabled. EventBridge does not match any
#'     events against the rule.
#' 
#' -   `ENABLED`: The rule is enabled. EventBridge matches events against
#'     the rule, *except* for Amazon Web Services management events
#'     delivered through CloudTrail.
#' 
#' -   `ENABLED_WITH_ALL_CLOUDTRAIL_MANAGEMENT_EVENTS`: The rule is enabled
#'     for all events, including Amazon Web Services management events
#'     delivered through CloudTrail.
#' 
#'     Management events provide visibility into management operations that
#'     are performed on resources in your Amazon Web Services account.
#'     These are also known as control plane operations. For more
#'     information, see [Logging management
#'     events](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html#logging-management-events)
#'     in the *CloudTrail User Guide*, and [Filtering management events
#'     from Amazon Web Services
#'     services](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-service-event.html#eb-service-event-cloudtrail)
#'     in the *Amazon EventBridge User Guide*.
#' 
#'     This value is only valid for rules on the
#'     [default](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-what-is-how-it-works-concepts.html#eb-bus-concepts-buses)
#'     event bus or [custom event
#'     buses](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-create-event-bus.html).
#'     It does not apply to [partner event
#'     buses](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-saas.html).
#' @param Description A description of the rule.
#' @param RoleArn The Amazon Resource Name (ARN) of the IAM role associated with the rule.
#' 
#' If you're setting an event bus in another account as the target and that
#' account granted permission to your account through an organization
#' instead of directly by the account ID, you must specify a `RoleArn` with
#' proper permissions in the `Target` structure, instead of here in this
#' parameter.
#' @param Tags The list of key-value pairs to associate with the rule.
#' @param EventBusName The name or ARN of the event bus to associate with this rule. If you
#' omit this, the default event bus is used.
#'
#' @keywords internal
#'
#' @rdname eventbridge_put_rule
eventbridge_put_rule <- function(Name, ScheduleExpression = NULL, EventPattern = NULL, State = NULL, Description = NULL, RoleArn = NULL, Tags = NULL, EventBusName = NULL) {
  op <- new_operation(
    name = "PutRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$put_rule_input(Name = Name, ScheduleExpression = ScheduleExpression, EventPattern = EventPattern, State = State, Description = Description, RoleArn = RoleArn, Tags = Tags, EventBusName = EventBusName)
  output <- .eventbridge$put_rule_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$put_rule <- eventbridge_put_rule

#' Adds the specified targets to the specified rule, or updates the targets
#' if they are already associated with the rule
#'
#' @description
#' Adds the specified targets to the specified rule, or updates the targets if they are already associated with the rule.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_put_targets/](https://www.paws-r-sdk.com/docs/eventbridge_put_targets/) for full documentation.
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#' @param Targets &#91;required&#93; The targets to update or add to the rule.
#'
#' @keywords internal
#'
#' @rdname eventbridge_put_targets
eventbridge_put_targets <- function(Rule, EventBusName = NULL, Targets) {
  op <- new_operation(
    name = "PutTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$put_targets_input(Rule = Rule, EventBusName = EventBusName, Targets = Targets)
  output <- .eventbridge$put_targets_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$put_targets <- eventbridge_put_targets

#' Revokes the permission of another Amazon Web Services account to be able
#' to put events to the specified event bus
#'
#' @description
#' Revokes the permission of another Amazon Web Services account to be able to put events to the specified event bus. Specify the account to revoke by the `StatementId` value that you associated with the account when you granted it permission with [`put_permission`][eventbridge_put_permission]. You can find the `StatementId` by using [`describe_event_bus`][eventbridge_describe_event_bus].
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_remove_permission/](https://www.paws-r-sdk.com/docs/eventbridge_remove_permission/) for full documentation.
#'
#' @param StatementId The statement ID corresponding to the account that is no longer allowed
#' to put events to the default event bus.
#' @param RemoveAllPermissions Specifies whether to remove all permissions.
#' @param EventBusName The name of the event bus to revoke permissions for. If you omit this,
#' the default event bus is used.
#'
#' @keywords internal
#'
#' @rdname eventbridge_remove_permission
eventbridge_remove_permission <- function(StatementId = NULL, RemoveAllPermissions = NULL, EventBusName = NULL) {
  op <- new_operation(
    name = "RemovePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$remove_permission_input(StatementId = StatementId, RemoveAllPermissions = RemoveAllPermissions, EventBusName = EventBusName)
  output <- .eventbridge$remove_permission_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$remove_permission <- eventbridge_remove_permission

#' Removes the specified targets from the specified rule
#'
#' @description
#' Removes the specified targets from the specified rule. When the rule is triggered, those targets are no longer be invoked.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_remove_targets/](https://www.paws-r-sdk.com/docs/eventbridge_remove_targets/) for full documentation.
#'
#' @param Rule &#91;required&#93; The name of the rule.
#' @param EventBusName The name or ARN of the event bus associated with the rule. If you omit
#' this, the default event bus is used.
#' @param Ids &#91;required&#93; The IDs of the targets to remove from the rule.
#' @param Force If this is a managed rule, created by an Amazon Web Services service on
#' your behalf, you must specify `Force` as `True` to remove targets. This
#' parameter is ignored for rules that are not managed rules. You can check
#' whether a rule is a managed rule by using
#' [`describe_rule`][eventbridge_describe_rule] or
#' [`list_rules`][eventbridge_list_rules] and checking the `ManagedBy`
#' field of the response.
#'
#' @keywords internal
#'
#' @rdname eventbridge_remove_targets
eventbridge_remove_targets <- function(Rule, EventBusName = NULL, Ids, Force = NULL) {
  op <- new_operation(
    name = "RemoveTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$remove_targets_input(Rule = Rule, EventBusName = EventBusName, Ids = Ids, Force = Force)
  output <- .eventbridge$remove_targets_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$remove_targets <- eventbridge_remove_targets

#' Starts the specified replay
#'
#' @description
#' Starts the specified replay. Events are not necessarily replayed in the exact same order that they were added to the archive. A replay processes events to replay based on the time in the event, and replays them using 1 minute intervals. If you specify an `EventStartTime` and an `EventEndTime` that covers a 20 minute time range, the events are replayed from the first minute of that 20 minute range first. Then the events from the second minute are replayed. You can use [`describe_replay`][eventbridge_describe_replay] to determine the progress of a replay. The value returned for `EventLastReplayedTime` indicates the time within the specified time range associated with the last event replayed.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_start_replay/](https://www.paws-r-sdk.com/docs/eventbridge_start_replay/) for full documentation.
#'
#' @param ReplayName &#91;required&#93; The name of the replay to start.
#' @param Description A description for the replay to start.
#' @param EventSourceArn &#91;required&#93; The ARN of the archive to replay events from.
#' @param EventStartTime &#91;required&#93; A time stamp for the time to start replaying events. Only events that
#' occurred between the `EventStartTime` and `EventEndTime` are replayed.
#' @param EventEndTime &#91;required&#93; A time stamp for the time to stop replaying events. Only events that
#' occurred between the `EventStartTime` and `EventEndTime` are replayed.
#' @param Destination &#91;required&#93; A `ReplayDestination` object that includes details about the destination
#' for the replay.
#'
#' @keywords internal
#'
#' @rdname eventbridge_start_replay
eventbridge_start_replay <- function(ReplayName, Description = NULL, EventSourceArn, EventStartTime, EventEndTime, Destination) {
  op <- new_operation(
    name = "StartReplay",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$start_replay_input(ReplayName = ReplayName, Description = Description, EventSourceArn = EventSourceArn, EventStartTime = EventStartTime, EventEndTime = EventEndTime, Destination = Destination)
  output <- .eventbridge$start_replay_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$start_replay <- eventbridge_start_replay

#' Assigns one or more tags (key-value pairs) to the specified EventBridge
#' resource
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified EventBridge resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In EventBridge, rules and event buses can be tagged.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_tag_resource/](https://www.paws-r-sdk.com/docs/eventbridge_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of the EventBridge resource that you're adding tags to.
#' @param Tags &#91;required&#93; The list of key-value pairs to associate with the resource.
#'
#' @keywords internal
#'
#' @rdname eventbridge_tag_resource
eventbridge_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .eventbridge$tag_resource_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$tag_resource <- eventbridge_tag_resource

#' Tests whether the specified event pattern matches the provided event
#'
#' @description
#' Tests whether the specified event pattern matches the provided event.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_test_event_pattern/](https://www.paws-r-sdk.com/docs/eventbridge_test_event_pattern/) for full documentation.
#'
#' @param EventPattern &#91;required&#93; The event pattern. For more information, see [Events and Event
#' Patterns](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html)
#' in the *Amazon EventBridge User Guide*.
#' @param Event &#91;required&#93; The event, in JSON format, to test against the event pattern. The JSON
#' must follow the format specified in [Amazon Web Services
#' Events](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-events.html),
#' and the following fields are mandatory:
#' 
#' -   `id`
#' 
#' -   `account`
#' 
#' -   `source`
#' 
#' -   `time`
#' 
#' -   `region`
#' 
#' -   `resources`
#' 
#' -   `detail-type`
#'
#' @keywords internal
#'
#' @rdname eventbridge_test_event_pattern
eventbridge_test_event_pattern <- function(EventPattern, Event) {
  op <- new_operation(
    name = "TestEventPattern",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$test_event_pattern_input(EventPattern = EventPattern, Event = Event)
  output <- .eventbridge$test_event_pattern_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$test_event_pattern <- eventbridge_test_event_pattern

#' Removes one or more tags from the specified EventBridge resource
#'
#' @description
#' Removes one or more tags from the specified EventBridge resource. In Amazon EventBridge (CloudWatch Events), rules and event buses can be tagged.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_untag_resource/](https://www.paws-r-sdk.com/docs/eventbridge_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; The ARN of the EventBridge resource from which you are removing tags.
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname eventbridge_untag_resource
eventbridge_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .eventbridge$untag_resource_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$untag_resource <- eventbridge_untag_resource

#' Updates an API destination
#'
#' @description
#' Updates an API destination.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_update_api_destination/](https://www.paws-r-sdk.com/docs/eventbridge_update_api_destination/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the API destination to update.
#' @param Description The name of the API destination to update.
#' @param ConnectionArn The ARN of the connection to use for the API destination.
#' @param InvocationEndpoint The URL to the endpoint to use for the API destination.
#' @param HttpMethod The method to use for the API destination.
#' @param InvocationRateLimitPerSecond The maximum number of invocations per second to send to the API
#' destination.
#'
#' @keywords internal
#'
#' @rdname eventbridge_update_api_destination
eventbridge_update_api_destination <- function(Name, Description = NULL, ConnectionArn = NULL, InvocationEndpoint = NULL, HttpMethod = NULL, InvocationRateLimitPerSecond = NULL) {
  op <- new_operation(
    name = "UpdateApiDestination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$update_api_destination_input(Name = Name, Description = Description, ConnectionArn = ConnectionArn, InvocationEndpoint = InvocationEndpoint, HttpMethod = HttpMethod, InvocationRateLimitPerSecond = InvocationRateLimitPerSecond)
  output <- .eventbridge$update_api_destination_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$update_api_destination <- eventbridge_update_api_destination

#' Updates the specified archive
#'
#' @description
#' Updates the specified archive.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_update_archive/](https://www.paws-r-sdk.com/docs/eventbridge_update_archive/) for full documentation.
#'
#' @param ArchiveName &#91;required&#93; The name of the archive to update.
#' @param Description The description for the archive.
#' @param EventPattern The event pattern to use to filter events sent to the archive.
#' @param RetentionDays The number of days to retain events in the archive.
#'
#' @keywords internal
#'
#' @rdname eventbridge_update_archive
eventbridge_update_archive <- function(ArchiveName, Description = NULL, EventPattern = NULL, RetentionDays = NULL) {
  op <- new_operation(
    name = "UpdateArchive",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$update_archive_input(ArchiveName = ArchiveName, Description = Description, EventPattern = EventPattern, RetentionDays = RetentionDays)
  output <- .eventbridge$update_archive_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$update_archive <- eventbridge_update_archive

#' Updates settings for a connection
#'
#' @description
#' Updates settings for a connection.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_update_connection/](https://www.paws-r-sdk.com/docs/eventbridge_update_connection/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the connection to update.
#' @param Description A description for the connection.
#' @param AuthorizationType The type of authorization to use for the connection.
#' @param AuthParameters The authorization parameters to use for the connection.
#'
#' @keywords internal
#'
#' @rdname eventbridge_update_connection
eventbridge_update_connection <- function(Name, Description = NULL, AuthorizationType = NULL, AuthParameters = NULL) {
  op <- new_operation(
    name = "UpdateConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$update_connection_input(Name = Name, Description = Description, AuthorizationType = AuthorizationType, AuthParameters = AuthParameters)
  output <- .eventbridge$update_connection_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$update_connection <- eventbridge_update_connection

#' Update an existing endpoint
#'
#' @description
#' Update an existing endpoint. For more information about global endpoints, see [Making applications Regional-fault tolerant with global endpoints and event replication](https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-global-endpoints.html) in the *Amazon EventBridge User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/eventbridge_update_endpoint/](https://www.paws-r-sdk.com/docs/eventbridge_update_endpoint/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the endpoint you want to update.
#' @param Description A description for the endpoint.
#' @param RoutingConfig Configure the routing policy, including the health check and secondary
#' Region.
#' @param ReplicationConfig Whether event replication was enabled or disabled by this request.
#' @param EventBuses Define event buses used for replication.
#' @param RoleArn The ARN of the role used by event replication for this request.
#'
#' @keywords internal
#'
#' @rdname eventbridge_update_endpoint
eventbridge_update_endpoint <- function(Name, Description = NULL, RoutingConfig = NULL, ReplicationConfig = NULL, EventBuses = NULL, RoleArn = NULL) {
  op <- new_operation(
    name = "UpdateEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .eventbridge$update_endpoint_input(Name = Name, Description = Description, RoutingConfig = RoutingConfig, ReplicationConfig = ReplicationConfig, EventBuses = EventBuses, RoleArn = RoleArn)
  output <- .eventbridge$update_endpoint_output()
  config <- get_config()
  svc <- .eventbridge$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eventbridge$operations$update_endpoint <- eventbridge_update_endpoint
