% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_get_queue_attributes}
\alias{sqs_get_queue_attributes}
\title{Gets attributes for the specified queue}
\usage{
sqs_get_queue_attributes(QueueUrl, AttributeNames)
}
\arguments{
\item{QueueUrl}{[required] The URL of the Amazon SQS queue whose attribute information is
retrieved.

Queue URLs and names are case-sensitive.}

\item{AttributeNames}{A list of attributes for which to retrieve information.

In the future, new attributes might be added. If you write code that
calls this action, we recommend that you structure your code so that it
can handle new attributes gracefully.

The following attributes are supported:

The \code{ApproximateNumberOfMessagesDelayed},
\code{ApproximateNumberOfMessagesNotVisible}, and
\code{ApproximateNumberOfMessagesVisible} metrics may not achieve consistency
until at least 1 minute after the producers stop sending messages. This
period is required for the queue metadata to reach eventual consistency.
\itemize{
\item \code{All} -- Returns all values.
\item \code{ApproximateNumberOfMessages} -- Returns the approximate number of
messages available for retrieval from the queue.
\item \code{ApproximateNumberOfMessagesDelayed} -- Returns the approximate
number of messages in the queue that are delayed and not available
for reading immediately. This can happen when the queue is
configured as a delay queue or when a message has been sent with a
delay parameter.
\item \code{ApproximateNumberOfMessagesNotVisible} -- Returns the approximate
number of messages that are in flight. Messages are considered to be
\emph{in flight} if they have been sent to a client but have not yet been
deleted or have not yet reached the end of their visibility window.
\item \code{CreatedTimestamp} -- Returns the time when the queue was created in
seconds (\href{http://en.wikipedia.org/wiki/Unix_time}{epoch time}).
\item \code{DelaySeconds} -- Returns the default delay on the queue in seconds.
\item \code{LastModifiedTimestamp} -- Returns the time when the queue was last
changed in seconds (\href{http://en.wikipedia.org/wiki/Unix_time}{epoch time}).
\item \code{MaximumMessageSize} -- Returns the limit of how many bytes a
message can contain before Amazon SQS rejects it.
\item \code{MessageRetentionPeriod} -- Returns the length of time, in seconds,
for which Amazon SQS retains a message.
\item \code{Policy} -- Returns the policy of the queue.
\item \code{QueueArn} -- Returns the Amazon resource name (ARN) of the queue.
\item \code{ReceiveMessageWaitTimeSeconds} -- Returns the length of time, in
seconds, for which the \code{ReceiveMessage} action waits for a message
to arrive.
\item \code{RedrivePolicy} -- The string that includes the parameters for the
dead-letter queue functionality of the source queue as a JSON
object. For more information about the redrive policy and
dead-letter queues, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-dead-letter-queues.html}{Using Amazon SQS Dead-Letter Queues}
in the \emph{Amazon Simple Queue Service Developer Guide}.
\itemize{
\item \code{deadLetterTargetArn} -- The Amazon Resource Name (ARN) of the
dead-letter queue to which Amazon SQS moves messages after the
value of \code{maxReceiveCount} is exceeded.
\item \code{maxReceiveCount} -- The number of times a message is delivered
to the source queue before being moved to the dead-letter queue.
When the \code{ReceiveCount} for a message exceeds the
\code{maxReceiveCount} for a queue, Amazon SQS moves the message to
the dead-letter-queue.
}
\item \code{VisibilityTimeout} -- Returns the visibility timeout for the queue.
For more information about the visibility timeout, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-visibility-timeout.html}{Visibility Timeout}
in the \emph{Amazon Simple Queue Service Developer Guide}.
}

The following attributes apply only to
\href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html}{server-side-encryption}:
\itemize{
\item \code{KmsMasterKeyId} -- Returns the ID of an AWS-managed customer master
key (CMK) for Amazon SQS or a custom CMK. For more information, see
\href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-sse-key-terms}{Key Terms}.
\item \code{KmsDataKeyReusePeriodSeconds} -- Returns the length of time, in
seconds, for which Amazon SQS can reuse a data key to encrypt or
decrypt messages before calling AWS KMS again. For more information,
see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-server-side-encryption.html#sqs-how-does-the-data-key-reuse-period-work}{How Does the Data Key Reuse Period Work?}.
}

The following attributes apply only to \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html}{FIFO (first-in-first-out) queues}:
\itemize{
\item \code{FifoQueue} -- Returns whether the queue is FIFO. For more
information, see \href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-understanding-logic}{FIFO Queue Logic}
in the \emph{Amazon Simple Queue Service Developer Guide}.

To determine whether a queue is
\href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html}{FIFO},
you can check whether \code{QueueName} ends with the \code{.fifo} suffix.
\item \code{ContentBasedDeduplication} -- Returns whether content-based
deduplication is enabled for the queue. For more information, see
\href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html#FIFO-queues-exactly-once-processing}{Exactly-Once Processing}
in the \emph{Amazon Simple Queue Service Developer Guide}.
}}
}
\description{
Gets attributes for the specified queue.
}
\details{
To determine whether a queue is
\href{https://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/FIFO-queues.html}{FIFO},
you can check whether \code{QueueName} ends with the \code{.fifo} suffix.
}
\section{Request syntax}{
\preformatted{svc$get_queue_attributes(
  QueueUrl = "string",
  AttributeNames = list(
    "All"|"Policy"|"VisibilityTimeout"|"MaximumMessageSize"|"MessageRetentionPeriod"|"ApproximateNumberOfMessages"|"ApproximateNumberOfMessagesNotVisible"|"CreatedTimestamp"|"LastModifiedTimestamp"|"QueueArn"|"ApproximateNumberOfMessagesDelayed"|"DelaySeconds"|"ReceiveMessageWaitTimeSeconds"|"RedrivePolicy"|"FifoQueue"|"ContentBasedDeduplication"|"KmsMasterKeyId"|"KmsDataKeyReusePeriodSeconds"
  )
)
}
}

\keyword{internal}
