% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_list_executions}
\alias{sfn_list_executions}
\title{Lists the executions of a state machine that meet the filtering criteria}
\usage{
sfn_list_executions(stateMachineArn, statusFilter, maxResults,
  nextToken)
}
\arguments{
\item{stateMachineArn}{[required] The Amazon Resource Name (ARN) of the state machine whose executions is
listed.}

\item{statusFilter}{If specified, only list the executions whose current execution status
matches the given filter.}

\item{maxResults}{The maximum number of results that are returned per call. You can use
\code{nextToken} to obtain further pages of results. The default is 100 and
the maximum allowed page size is 1000. A value of 0 uses the default.

This is only an upper limit. The actual number of results returned per
call might be fewer than the specified maximum.}

\item{nextToken}{If \code{nextToken} is returned, there are more results available. The value
of \code{nextToken} is a unique pagination token for each page. Make the call
again using the returned token to retrieve the next page. Keep all other
arguments unchanged. Each pagination token expires after 24 hours. Using
an expired pagination token will return an \emph{HTTP 400 InvalidToken}
error.}
}
\description{
Lists the executions of a state machine that meet the filtering
criteria. Results are sorted by time, with the most recent execution
first.
}
\details{
If \code{nextToken} is returned, there are more results available. The value
of \code{nextToken} is a unique pagination token for each page. Make the call
again using the returned token to retrieve the next page. Keep all other
arguments unchanged. Each pagination token expires after 24 hours. Using
an expired pagination token will return an \emph{HTTP 400 InvalidToken}
error.

This operation is eventually consistent. The results are best effort and
may not reflect very recent updates and changes.

This API action is not supported by \code{EXPRESS} state machines.
}
\section{Request syntax}{
\preformatted{svc$list_executions(
  stateMachineArn = "string",
  statusFilter = "RUNNING"|"SUCCEEDED"|"FAILED"|"TIMED_OUT"|"ABORTED",
  maxResults = 123,
  nextToken = "string"
)
}
}

\keyword{internal}
