% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_start_execution}
\alias{sfn_start_execution}
\title{Starts a state machine execution}
\usage{
sfn_start_execution(stateMachineArn, name, input)
}
\arguments{
\item{stateMachineArn}{[required] The Amazon Resource Name (ARN) of the state machine to execute.}

\item{name}{The name of the execution. This name must be unique for your AWS
account, region, and state machine for 90 days. For more information,
see \href{https://docs.aws.amazon.com/step-functions/latest/dg/limits.html#service-limits-state-machine-executions}{Limits Related to State Machine Executions}
in the \emph{AWS Step Functions Developer Guide}.

A name must \emph{not} contain:
\itemize{
\item white space
\item brackets \verb{&lt; &gt; \\\{ \\\} \\\[ \\\]}
\item wildcard characters \verb{? *}
\item special characters \verb{\\" # \\\% \\\\ ^ | ~ \\` $ &amp; , ; : /}
\item control characters (\verb{U+0000-001F}, \verb{U+007F-009F})
}}

\item{input}{The string that contains the JSON input data for the execution, for
example:

\verb{"input": "\\\{\\"first_name\\" : \\"test\\"\\\}"}

If you don\'t include any JSON input data, you still must include the
two braces, for example: \code{"input": "\\{\\}"}}
}
\description{
Starts a state machine execution.
}
\details{
\code{StartExecution} is idempotent. If \code{StartExecution} is called with the
same name and input as a running execution, the call will succeed and
return the same response as the original request. If the execution is
closed or if the input is different, it will return a 400
\code{ExecutionAlreadyExists} error. Names can be reused after 90 days.
}
\section{Request syntax}{
\preformatted{svc$start_execution(
  stateMachineArn = "string",
  name = "string",
  input = "string"
)
}
}

\keyword{internal}
