% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_list_query_executions}
\alias{athena_list_query_executions}
\title{Provides a list of available query execution IDs for the queries in the
specified workgroup}
\usage{
athena_list_query_executions(
  NextToken = NULL,
  MaxResults = NULL,
  WorkGroup = NULL
)
}
\arguments{
\item{NextToken}{A token generated by the Athena service that specifies where to continue
pagination if a previous request was truncated. To obtain the next set
of pages, pass in the \code{NextToken} from the response object of the
previous page call.}

\item{MaxResults}{The maximum number of query executions to return in this request.}

\item{WorkGroup}{The name of the workgroup from which queries are being returned. If a
workgroup is not specified, a list of available query execution IDs for
the queries in the primary workgroup is returned.}
}
\description{
Provides a list of available query execution IDs for the queries in the specified workgroup. Athena keeps a query history for 45 days. If a workgroup is not specified, returns a list of query execution IDs for the primary workgroup. Requires you to have access to the workgroup in which the queries ran.

See \url{https://www.paws-r-sdk.com/docs/athena_list_query_executions/} for full documentation.
}
\keyword{internal}
