% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opensearchserviceserverless_operations.R
\name{opensearchserviceserverless_create_access_policy}
\alias{opensearchserviceserverless_create_access_policy}
\title{Creates a data access policy for OpenSearch Serverless}
\usage{
opensearchserviceserverless_create_access_policy(
  clientToken = NULL,
  description = NULL,
  name,
  policy,
  type
)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier to ensure idempotency of the request.}

\item{description}{A description of the policy. Typically used to store information about
the permissions defined in the policy.}

\item{name}{[required] The name of the policy.}

\item{policy}{[required] The JSON policy document to use as the content for the policy.}

\item{type}{[required] The type of policy.}
}
\description{
Creates a data access policy for OpenSearch Serverless. Access policies limit access to collections and the resources within them, and allow a user to access that data irrespective of the access mechanism or network source. For more information, see \href{https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html}{Data access control for Amazon OpenSearch Serverless}.

See \url{https://www.paws-r-sdk.com/docs/opensearchserviceserverless_create_access_policy/} for full documentation.
}
\keyword{internal}
